/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnBase64$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str) - Converts the argument from a base 64 string `str` to a binary.", examples="\n    Examples:\n      > SELECT _FUNC_('U3BhcmsgU1FM');\n       Spark SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Uh\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003Q\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011P\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015!\u0006\u0001\"\u0001k\u0011\u0015i\u0007\u0001\"\u0015o\u0011\u0015!\b\u0001\"\u0011v\u0011\u001d\t9\u0001\u0001C)\u0003\u0013A\u0011\"a\u0004\u0001\u0003\u0003%\t!!\u0005\t\u0013\u0005]\u0001!%A\u0005\u0002\u0005e\u0001\"CA\u0018\u0001E\u0005I\u0011AA\u0019\u0011%\t)\u0004AA\u0001\n\u0003\n9\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f\u001d\ti*\tE\u0001\u0003?3a\u0001I\u0011\t\u0002\u0005\u0005\u0006B\u0002+\u0019\t\u0003\t\u0019\fC\u0004\u00026b!\t!a.\t\u0013\u0005-\u0007$!A\u0005\u0002\u00065\u0007\"CAj1E\u0005I\u0011AA\u0019\u0011%\t)\u000eGA\u0001\n\u0003\u000b9\u000eC\u0005\u0002jb\t\n\u0011\"\u0001\u00022!I\u00111\u001e\r\u0002\u0002\u0013%\u0011Q\u001e\u0002\t+:\u0014\u0015m]37i)\u0011!eI\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002%K\u0005A1-\u0019;bYf\u001cHO\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001_M2D\b\u0005\u00021c5\t\u0011%\u0003\u00023C\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00021i%\u0011Q'\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t9\u0001K]8ek\u000e$\bCA\u001fF\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B[\u00051AH]8pizJ\u0011!O\u0005\u0003\tb\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\na1+\u001a:jC2L'0\u00192mK*\u0011A\tO\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0015B\u0011\u0001gS\u0005\u0003\u0019\u0006\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u0005Ya-Y5m\u001f:,%O]8s+\u0005\u0001\u0006CA\u001cR\u0013\t\u0011\u0006HA\u0004C_>dW-\u00198\u0002\u0019\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN\u001d\u0011\u0002\rqJg.\u001b;?)\r1v\u000b\u0017\t\u0003a\u0001AQ\u0001S\u0003A\u0002)CqAT\u0003\u0011\u0002\u0003\u0007\u0001+\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0016\nQ\u0001^=qKNL!!\u00190\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005!\u0007cA\u001ffO&\u0011am\u0012\u0002\u0004'\u0016\f\bCA/i\u0013\tIgL\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qKR\u0011ak\u001b\u0005\u0006Y&\u0001\rAS\u0001\u0005Kb\u0004(/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002peB\u0011q\u0007]\u0005\u0003cb\u00121!\u00118z\u0011\u0015\u0019(\u00021\u0001p\u0003\u0019\u0019HO]5oO\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005mr\f\u0019\u0001\u0005\u0002xu6\t\u0001P\u0003\u0002zC\u000591m\u001c3fO\u0016t\u0017BA>y\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B?\f\u0001\u0004q\u0018aA2uqB\u0011qo`\u0005\u0004\u0003\u0003A(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u000bY\u0001\u0019\u0001<\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002W\u0003\u0017Aa!!\u0004\r\u0001\u0004Q\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0006-\u0006M\u0011Q\u0003\u0005\b\u00116\u0001\n\u00111\u0001K\u0011\u001dqU\u0002%AA\u0002A\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001c)\u001a!*!\b,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000b9\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00024)\u001a\u0001+!\b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0015SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\nAA[1wC&!\u0011qIA\u001f\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\n\t\u0004o\u0005=\u0013bAA)q\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019q.a\u0016\t\u0013\u0005e##!AA\u0002\u00055\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002`A)\u0011\u0011MA4_6\u0011\u00111\r\u0006\u0004\u0003KB\u0014AC2pY2,7\r^5p]&!\u0011\u0011NA2\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007A\u000by\u0007\u0003\u0005\u0002ZQ\t\t\u00111\u0001p\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u0012Q\u000f\u0005\n\u00033*\u0012\u0011!a\u0001\u0003\u001b\na!Z9vC2\u001cHc\u0001)\u0002|!A\u0011\u0011\f\f\u0002\u0002\u0003\u0007q\u000eK\n\u0001\u0003\u007f\n))a\"\u0002\f\u00065\u0015\u0011SAJ\u0003/\u000bI\nE\u00021\u0003\u0003K1!a!\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!#\u0002\u0019~3UKT\"`QM$(/\u000b\u0011.A\r{gN^3siN\u0004C\u000f[3!CJ<W/\\3oi\u00022'o\\7!C\u0002\u0012\u0017m]3!mQ\u00023\u000f\u001e:j]\u001e\u0004\u0003m\u001d;sA\u0002\"x\u000eI1!E&t\u0017M]=/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAH\u0003%S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ+4\u0005\"\u001cWn]4Vc\u0019ku%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!'B\f'o\u001b\u0011T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003+\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a'\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0011Us')Y:fmQ\u0002\"\u0001\r\r\u0014\u000ba\t\u0019+!+\u0011\u0007]\n)+C\u0002\u0002(b\u0012a!\u00118z%\u00164\u0007\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u0016\u0011I\u0001\u0003S>L1ARAW)\t\ty*A\u0007jgZ\u000bG.\u001b3CCN,g\u0007\u000e\u000b\u0004!\u0006e\u0006bBA^5\u0001\u0007\u0011QX\u0001\ngJ\u001c7\u000b\u001e:j]\u001e\u0004B!a0\u0002H6\u0011\u0011\u0011\u0019\u0006\u0004?\u0006\r'bAAcO\u00051QO\\:bM\u0016LA!!3\u0002B\nQQ\u000b\u0016$9'R\u0014\u0018N\\4\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bY\u000by-!5\t\u000b![\u0002\u0019\u0001&\t\u000f9[\u0002\u0013!a\u0001!\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0017Q\u001d\t\u0006o\u0005m\u0017q\\\u0005\u0004\u0003;D$AB(qi&|g\u000eE\u00038\u0003CT\u0005+C\u0002\u0002db\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAt;\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003_\u0004B!a\u000f\u0002r&!\u00111_A\u001f\u0005\u0019y%M[3di\u0002")
public class UnBase64
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$2() {
        return UnBase64$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnBase64 x$0) {
        return UnBase64$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnBase64$.MODULE$.apply$default$2();
    }

    public static boolean isValidBase64(UTF8String srcString) {
        return UnBase64$.MODULE$.isValidBase64(srcString);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object string) {
        if (this.failOnError() && !UnBase64$.MODULE$.isValidBase64((UTF8String)string)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInConversionError((DataType)BinaryType$.MODULE$, (UTF8String)string, UTF8String.fromString((String)"BASE64"), "try_to_binary");
        }
        return Base64.getMimeDecoder().decode(((UTF8String)string).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)child -> {
            String string;
            if (this.failOnError()) {
                String unbase64 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(UnBase64$.MODULE$.getClass().getName()), "$");
                String binaryType = ctx.addReferenceObj("to", BinaryType$.MODULE$, BinaryType$.MODULE$.getClass().getName());
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + unbase64 + ".isValidBase64(" + child + ")) {\n           |  throw QueryExecutionErrors.invalidInputInConversionError(\n           |    " + binaryType + ",\n           |    " + child + ",\n           |    UTF8String.fromString(\"BASE64\"),\n           |    \"try_to_binary\");\n           |}\n       "));
            } else {
                string = "";
            }
            String maybeValidateInputCode = string;
            return "\n         " + maybeValidateInputCode + "\n         " + ev.value() + " = " + Base64.class.getName() + ".getMimeDecoder().decode(" + child + ".toString());\n       ";
        });
    }

    @Override
    public UnBase64 withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.failOnError());
    }

    public UnBase64 copy(Expression child, boolean failOnError) {
        return new UnBase64(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnBase64";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnBase64;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnBase64)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnBase64 unBase64 = (UnBase64)x$1;
        if (this.failOnError() != unBase64.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unBase64.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unBase64.canEqual(this)) return false;
        return true;
    }

    public UnBase64(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnBase64(Expression expr) {
        this(expr, false);
    }
}

