/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.fpm.PrefixSpan;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaPrefixSpanExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaPrefixSpanExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3))}), RowFactory.create((Object[])new Object[]{Arrays.asList(Arrays.asList(1), Arrays.asList(3, 2), Arrays.asList(1, 2))}), RowFactory.create((Object[])new Object[]{Arrays.asList(Arrays.asList(1, 2), Arrays.asList(5))}), RowFactory.create((Object[])new Object[]{Arrays.asList(Arrays.asList(6))}));
        StructType schema = new StructType(new StructField[]{new StructField("sequence", (DataType)new ArrayType((DataType)new ArrayType(DataTypes.IntegerType, true), true), false, Metadata.empty())});
        Dataset sequenceDF = spark.createDataFrame(data, schema);
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
        prefixSpan.findFrequentSequentialPatterns(sequenceDF).show();
        spark.stop();
    }
}

