/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction1;

public final class MulticlassMetricsExample$ {
    public static final MulticlassMetricsExample$ MODULE$ = new MulticlassMetricsExample$();

    public void main(String[] args) {
        Object object;
        SparkConf conf = new SparkConf().setAppName("MulticlassMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_multiclass_classification_data.txt");
        RDD[] rDDArray = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        if (rDDArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)rDDArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)rDDArray);
        }
        RDD training = (RDD)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        RDD test = (RDD)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)training, (Object)test);
        RDD training2 = (RDD)tuple2._1();
        RDD test2 = (RDD)tuple2._2();
        training2.cache();
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(3).run(training2);
        RDD predictionAndLabels = test2.map((Function1 & Serializable)x0$1 -> {
            LabeledPoint labeledPoint = x0$1;
            if (labeledPoint != null) {
                double label = labeledPoint.label();
                Vector features = labeledPoint.features();
                double prediction = model.predict(features);
                return new Tuple2.mcDD.sp(prediction, label);
            }
            throw new MatchError((Object)labeledPoint);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels);
        Predef$.MODULE$.println((Object)"Confusion matrix:");
        Predef$.MODULE$.println((Object)metrics.confusionMatrix());
        double accuracy = metrics.accuracy();
        Predef$.MODULE$.println((Object)"Summary Statistics");
        Predef$.MODULE$.println((Object)("Accuracy = " + accuracy));
        double[] labels = metrics.labels();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(labels), (Function1)(JFunction1.mcVD.sp & Serializable)l -> Predef$.MODULE$.println((Object)("Precision(" + l + ") = " + metrics.precision(l))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(labels), (Function1)(JFunction1.mcVD.sp & Serializable)l -> Predef$.MODULE$.println((Object)("Recall(" + l + ") = " + metrics.recall(l))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(labels), (Function1)(JFunction1.mcVD.sp & Serializable)l -> Predef$.MODULE$.println((Object)("FPR(" + l + ") = " + metrics.falsePositiveRate(l))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(labels), (Function1)(JFunction1.mcVD.sp & Serializable)l -> Predef$.MODULE$.println((Object)("F1-Score(" + l + ") = " + metrics.fMeasure(l))));
        Predef$.MODULE$.println((Object)("Weighted precision: " + metrics.weightedPrecision()));
        Predef$.MODULE$.println((Object)("Weighted recall: " + metrics.weightedRecall()));
        Predef$.MODULE$.println((Object)("Weighted F1 score: " + metrics.weightedFMeasure()));
        Predef$.MODULE$.println((Object)("Weighted false positive rate: " + metrics.weightedFalsePositiveRate()));
        sc.stop();
    }

    private MulticlassMetricsExample$() {
    }
}

