/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.StateTTL$;
import org.apache.spark.sql.execution.streaming.StateTypesEncoder$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\u000e\u001d\u0001%B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d\u0011\u0007A1A\u0005\n\rDaa\u001e\u0001!\u0002\u0013!\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007w\u0002\u0001\u000b\u0011\u0002>\t\u000fq\u0004!\u0019!C\u0005{\"1q\u0010\u0001Q\u0001\nyD\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005-\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0004\u0001\u0005\u0004%I!a\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003#Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005%\u0002\u0001\"\u0001\u00022!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA+\u000f\u001d\ti\u0006\bE\u0001\u0003?2aa\u0007\u000f\t\u0002\u0005\u0005\u0004B\u0002.\u0018\t\u0003\t\u0019\u0007C\u0004\u0002f]!\t!a\u001a\t\u0013\u0005mt#%A\u0005\u0002\u0005u$!E*uCR,G+\u001f9fg\u0016s7m\u001c3fe*\u0011QDH\u0001\ngR\u0014X-Y7j]\u001eT!a\b\u0011\u0002\u0013\u0015DXmY;uS>t'BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u0001QC\u0001\u0016E'\t\u00011\u0006\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VMZ\u0001\u000bW\u0016LXI\\2pI\u0016\u0014\bcA\u001a9u5\tAG\u0003\u00026m\u0005AQM\\2pI\u0016\u00148O\u0003\u00028A\u0005A1-\u0019;bYf\u001cH/\u0003\u0002:i\t\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\u0011\u00051Z\u0014B\u0001\u001f.\u0005\r\te._\u0001\u000bm\u0006dWI\\2pI\u0016\u0014\bcA A\u00056\t\u0001%\u0003\u0002BA\t9QI\\2pI\u0016\u0014\bCA\"E\u0019\u0001!Q!\u0012\u0001C\u0002\u0019\u0013\u0011AV\t\u0003\u000fj\u0002\"\u0001\f%\n\u0005%k#a\u0002(pi\"LgnZ\u0001\ngR\fG/\u001a(b[\u0016\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(.\u001b\u0005y%B\u0001))\u0003\u0019a$o\\8u}%\u0011!+L\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S[\u00051\u0001.Y:Ui2\u0004\"\u0001\f-\n\u0005ek#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bqsv\fY1\u0011\u0007u\u0003!)D\u0001\u001d\u0011\u0015\tT\u00011\u00013\u0011\u0015iT\u00011\u0001?\u0011\u0015QU\u00011\u0001L\u0011\u00151V\u00011\u0001X\u00035YW-_*fe&\fG.\u001b>feV\tA\rE\u0002fijr!A\u001a:\u000f\u0005\u001d\fhB\u00015q\u001d\tIwN\u0004\u0002k]:\u00111.\u001c\b\u0003\u001d2L\u0011aJ\u0005\u0003K\u0019J!a\t\u0013\n\u0005\u0005\u0012\u0013BA\u001c!\u0013\t)d'\u0003\u0002ti\u0005\tR\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e|G-\u001a:\n\u0005U4(AC*fe&\fG.\u001b>fe*\u00111\u000fN\u0001\u000fW\u0016L8+\u001a:jC2L'0\u001a:!\u0003A1\u0018\r\\#yaJ,7o]5p]\u0016s7-F\u0001{!\r\u0019\u0004HQ\u0001\u0012m\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8F]\u000e\u0004\u0013AE8cUR{'k\\<TKJL\u0017\r\\5{KJ,\u0012A \t\u0004KR\u0014\u0015aE8cUR{'k\\<TKJL\u0017\r\\5{KJ\u0004\u0013\u0001\u0006:poR{wJ\u00196EKN,'/[1mSj,'/\u0006\u0002\u0002\u0006A!Q-a\u0002C\u0013\r\tIA\u001e\u0002\r\t\u0016\u001cXM]5bY&TXM]\u0001\u0016e><Hk\\(cU\u0012+7/\u001a:jC2L'0\u001a:!\u0003I1\u0018\r\\;f)Rc\u0005K]8kK\u000e$\u0018n\u001c8\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]a'A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u000e\u0003+\u0011\u0001#\u00168tC\u001a,\u0007K]8kK\u000e$\u0018n\u001c8\u0002'Y\fG.^3U)2\u0003&o\u001c6fGRLwN\u001c\u0011\u0002#\u0015t7m\u001c3f\u000fJ|W\u000f]5oO.+\u0017\u0010\u0006\u0002\u0002$A!\u00111CA\u0013\u0013\u0011\t9#!\u0006\u0003\u0013Us7/\u00194f%><\u0018aC3oG>$WMV1mk\u0016$B!a\t\u0002.!1\u0011qF\tA\u0002\t\u000bQA^1mk\u0016$b!a\t\u00024\u0005U\u0002BBA\u0018%\u0001\u0007!\tC\u0004\u00028I\u0001\r!!\u000f\u0002\u0019\u0015D\b/\u001b:bi&|g.T:\u0011\u00071\nY$C\u0002\u0002>5\u0012A\u0001T8oO\u0006YA-Z2pI\u00164\u0016\r\\;f)\r\u0011\u00151\t\u0005\b\u0003\u000b\u001a\u0002\u0019AA\u0012\u0003\r\u0011xn^\u0001\u0016I\u0016\u001cw\u000eZ3Ui2,\u0005\u0010]5sCRLwN\\'t)\u0011\tY%!\u0015\u0011\u000b1\ni%!\u000f\n\u0007\u0005=SF\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u000b\"\u0002\u0019AA\u0012\u0003%I7/\u0012=qSJ,G\rF\u0003X\u0003/\nI\u0006C\u0004\u0002FU\u0001\r!a\t\t\u000f\u0005mS\u00031\u0001\u0002:\u0005\u0001\"-\u0019;dQRKW.Z:uC6\u0004Xj]\u0001\u0012'R\fG/\u001a+za\u0016\u001cXI\\2pI\u0016\u0014\bCA/\u0018'\t92\u0006\u0006\u0002\u0002`\u0005)\u0011\r\u001d9msV!\u0011\u0011NA8))\tY'!\u001d\u0002t\u0005]\u0014\u0011\u0010\t\u0005;\u0002\ti\u0007E\u0002D\u0003_\"Q!R\rC\u0002\u0019CQ!M\rA\u0002IBa!P\rA\u0002\u0005U\u0004\u0003B A\u0003[BQAS\rA\u0002-CqAV\r\u0011\u0002\u0003\u0007q+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\ty(!&\u0016\u0005\u0005\u0005%fA,\u0002\u0004.\u0012\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00106\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019*!#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003F5\t\u0007a\t")
public class StateTypesEncoder<V> {
    private final Encoder<V> valEncoder;
    private final String stateName;
    private final boolean hasTtl;
    private final ExpressionEncoder.Serializer<Object> keySerializer;
    private final ExpressionEncoder<V> valExpressionEnc;
    private final ExpressionEncoder.Serializer<V> objToRowSerializer;
    private final ExpressionEncoder.Deserializer<V> rowToObjDeserializer;
    private final UnsafeProjection valueTTLProjection;

    public static <V> boolean apply$default$4() {
        return StateTypesEncoder$.MODULE$.apply$default$4();
    }

    public static <V> StateTypesEncoder<V> apply(ExpressionEncoder<Object> keyEncoder, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        return StateTypesEncoder$.MODULE$.apply(keyEncoder, valEncoder, stateName, hasTtl);
    }

    private ExpressionEncoder.Serializer<Object> keySerializer() {
        return this.keySerializer;
    }

    private ExpressionEncoder<V> valExpressionEnc() {
        return this.valExpressionEnc;
    }

    private ExpressionEncoder.Serializer<V> objToRowSerializer() {
        return this.objToRowSerializer;
    }

    private ExpressionEncoder.Deserializer<V> rowToObjDeserializer() {
        return this.rowToObjDeserializer;
    }

    private UnsafeProjection valueTTLProjection() {
        return this.valueTTLProjection;
    }

    public UnsafeRow encodeGroupingKey() {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(this.stateName);
        }
        return (UnsafeRow)this.keySerializer().apply(keyOption.get());
    }

    public UnsafeRow encodeValue(V value) {
        return (UnsafeRow)this.objToRowSerializer().apply(value);
    }

    public UnsafeRow encodeValue(V value, long expirationMs) {
        InternalRow objRow = this.objToRowSerializer().apply(value);
        return this.valueTTLProjection().apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{objRow, BoxesRunTime.boxToLong((long)expirationMs)})));
    }

    public V decodeValue(UnsafeRow row) {
        if (this.hasTtl) {
            return (V)this.rowToObjDeserializer().apply((InternalRow)row.getStruct(0, this.valEncoder.schema().length()));
        }
        return (V)this.rowToObjDeserializer().apply((InternalRow)row);
    }

    public Option<Object> decodeTtlExpirationMs(UnsafeRow row) {
        Predef$.MODULE$.assert(this.hasTtl);
        long expirationMs = row.getLong(1);
        if (expirationMs == -1L) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)expirationMs));
    }

    public boolean isExpired(UnsafeRow row, long batchTimestampMs) {
        Option<Object> expirationMs = this.decodeTtlExpirationMs(row);
        return expirationMs.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$1 -> StateTTL$.MODULE$.isExpired(x$1, batchTimestampMs));
    }

    public StateTypesEncoder(ExpressionEncoder<Object> keyEncoder, Encoder<V> valEncoder, String stateName, boolean hasTtl) {
        this.valEncoder = valEncoder;
        this.stateName = stateName;
        this.hasTtl = hasTtl;
        this.keySerializer = keyEncoder.createSerializer();
        this.valExpressionEnc = package$.MODULE$.encoderFor(valEncoder);
        this.objToRowSerializer = this.valExpressionEnc().createSerializer();
        this.rowToObjDeserializer = this.valExpressionEnc().resolveAndBind(this.valExpressionEnc().resolveAndBind$default$1(), this.valExpressionEnc().resolveAndBind$default$2()).createDeserializer();
        this.valueTTLProjection = UnsafeProjection$.MODULE$.create(TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(valEncoder.schema(), true));
    }
}

