/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.MultipleWatermarkPolicy;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\t\u0013\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)A\b\u0001C\u0001{!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB-\u0001A\u0003%1\tC\u0004[\u0001\u0001\u0007I\u0011B.\t\u000fq\u0003\u0001\u0019!C\u0005;\"11\r\u0001Q!\nYCQ\u0001\u001a\u0001\u0005\u0002\u0015DQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001d\u0001\u0005\u0002mCa!\u001d\u0001\u0005\u0002Y\u0011x!B?\u0013\u0011\u0003qh!B\t\u0013\u0011\u0003y\bB\u0002\u001f\u000f\t\u0003\t\t\u0001C\u0004\u0002\u00049!\t!!\u0002\u0003!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014(BA\n\u0015\u0003%\u0019HO]3b[&twM\u0003\u0002\u0016-\u0005IQ\r_3dkRLwN\u001c\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(U5\t\u0001F\u0003\u0002*1\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002,Q\t9Aj\\4hS:<\u0017A\u00029pY&\u001c\u0017\u0010\u0005\u0002/_5\t!#\u0003\u00021%\t9R*\u001e7uSBdWmV1uKJl\u0017M]6Q_2L7-_\u0001\fS:LG/[1m!2\fg\u000e\u0005\u00024u5\tAG\u0003\u00026m\u00059An\\4jG\u0006d'BA\u001c9\u0003\u0015\u0001H.\u00198t\u0015\tId#\u0001\u0005dCR\fG._:u\u0013\tYDGA\u0006M_\u001eL7-\u00197QY\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002?\u007f\u0001\u0003\"A\f\u0001\t\u000b1\u001a\u0001\u0019A\u0017\t\u000bE\u001a\u0001\u0019\u0001\u001a\u0002-=\u0004XM]1u_J$vnV1uKJl\u0017M]6NCB,\u0012a\u0011\t\u0005\t&[5+D\u0001F\u0015\t1u)A\u0004nkR\f'\r\\3\u000b\u0005!\u0013\u0013AC2pY2,7\r^5p]&\u0011!*\u0012\u0002\u0004\u001b\u0006\u0004\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011)H/\u001b7\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\u0005+VKE\tE\u0002\")ZK!!\u0016\u0012\u0003\r=\u0003H/[8o!\t\ts+\u0003\u0002YE\t!Aj\u001c8h\u0003]y\u0007/\u001a:bi>\u0014Hk\\,bi\u0016\u0014X.\u0019:l\u001b\u0006\u0004\b%A\thY>\u0014\u0017\r\\,bi\u0016\u0014X.\u0019:l\u001bN,\u0012AV\u0001\u0016O2|'-\u00197XCR,'/\\1sW6\u001bx\fJ3r)\tq\u0016\r\u0005\u0002\"?&\u0011\u0001M\t\u0002\u0005+:LG\u000fC\u0004c\u000f\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0013'\u0001\nhY>\u0014\u0017\r\\,bi\u0016\u0014X.\u0019:l\u001bN\u0004\u0013\u0001D:fi^\u000bG/\u001a:nCJ\\GC\u00010g\u0011\u00159\u0017\u00021\u0001W\u00039qWm^,bi\u0016\u0014X.\u0019:l\u001bN\fq\"\u001e9eCR,w+\u0019;fe6\f'o\u001b\u000b\u0003=*DQa\u001b\u0006A\u00021\fA\"\u001a=fGV$X\r\u001a)mC:\u0004\"!\u001c8\u000e\u0003QI!a\u001c\u000b\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0017\u0001E2veJ,g\u000e^,bi\u0016\u0014X.\u0019:l\u000319\u0018\r^3s[\u0006\u00148.T1q+\u0005\u0019\b\u0003\u0002;|\u0017Ns!!^=\u0011\u0005Y\u0014S\"A<\u000b\u0005at\u0012A\u0002\u001fs_>$h(\u0003\u0002{E\u00051\u0001K]3eK\u001aL!A\u0013?\u000b\u0005i\u0014\u0013\u0001E,bi\u0016\u0014X.\u0019:l)J\f7m[3s!\tqcb\u0005\u0002\u000fAQ\ta0A\u0003baBd\u0017\u0010F\u0003?\u0003\u000f\t\u0019\u0002C\u0004\u0002\nA\u0001\r!a\u0003\u0002\t\r|gN\u001a\t\u0005\u0003\u001b\ty!D\u0001\u0017\u0013\r\t\tB\u0006\u0002\u000e%VtG/[7f\u0007>tg-[4\t\u000bE\u0002\u0002\u0019\u0001\u001a")
public class WatermarkTracker
implements Logging {
    private final MultipleWatermarkPolicy policy;
    private final Map<UUID, Option<Object>> operatorToWatermarkMap;
    private long globalWatermarkMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static WatermarkTracker apply(RuntimeConfig conf, LogicalPlan initialPlan) {
        return WatermarkTracker$.MODULE$.apply(conf, initialPlan);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Map<UUID, Option<Object>> operatorToWatermarkMap() {
        return this.operatorToWatermarkMap;
    }

    private long globalWatermarkMs() {
        return this.globalWatermarkMs;
    }

    private void globalWatermarkMs_$eq(long x$1) {
        this.globalWatermarkMs = x$1;
    }

    public synchronized void setWatermark(long newWatermarkMs) {
        this.globalWatermarkMs_$eq(newWatermarkMs);
    }

    public synchronized void updateWatermark(SparkPlan executedPlan) {
        Seq watermarkOperators = executedPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    return (B1)eventTimeWatermarkExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof EventTimeWatermarkExec;
            }
        });
        if (watermarkOperators.isEmpty()) {
            return;
        }
        watermarkOperators.foreach((Function1 & Serializable)x0$1 -> {
            EventTimeWatermarkExec eventTimeWatermarkExec = x0$1;
            if (eventTimeWatermarkExec.eventTimeStats().value().count() > 0L) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Observed event time stats " + eventTimeWatermarkExec.nodeId() + ": " + eventTimeWatermarkExec.eventTimeStats().value());
                if (!this.operatorToWatermarkMap().isDefinedAt((Object)eventTimeWatermarkExec.nodeId())) {
                    throw new IllegalStateException("Unknown watermark node ID: " + eventTimeWatermarkExec.nodeId() + ", known IDs: " + this.operatorToWatermarkMap().keys().mkString("[", ",", "]"));
                }
                long newWatermarkMs = eventTimeWatermarkExec.eventTimeStats().value().max() - eventTimeWatermarkExec.delayMs();
                Option prevWatermarkMs = (Option)this.operatorToWatermarkMap().apply((Object)eventTimeWatermarkExec.nodeId());
                if (prevWatermarkMs.isEmpty() || newWatermarkMs > BoxesRunTime.unboxToLong((Object)prevWatermarkMs.get())) {
                    return this.operatorToWatermarkMap().put((Object)eventTimeWatermarkExec.nodeId(), (Object)new Some((Object)BoxesRunTime.boxToLong((long)newWatermarkMs)));
                }
                return BoxedUnit.UNIT;
            }
            if (!this.operatorToWatermarkMap().isDefinedAt((Object)eventTimeWatermarkExec.nodeId())) {
                throw new IllegalStateException("Unknown watermark node ID: " + eventTimeWatermarkExec.nodeId() + ", known IDs: " + this.operatorToWatermarkMap().keys().mkString("[", ",", "]"));
            }
            return BoxedUnit.UNIT;
        });
        long chosenGlobalWatermark = this.policy.chooseGlobalWatermark((Seq<Object>)((IterableOnceOps)this.operatorToWatermarkMap().values().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)WatermarkTracker.$anonfun$updateWatermark$3(x$1)))).toSeq());
        if (chosenGlobalWatermark > this.globalWatermarkMs()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Updating event-time watermark from "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.GLOBAL_WATERMARK$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.globalWatermarkMs()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to ", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CHOSEN_WATERMARK$.MODULE$, (Object)BoxesRunTime.boxToLong((long)chosenGlobalWatermark))})))));
            this.globalWatermarkMs_$eq(chosenGlobalWatermark);
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Event time watermark didn't move: " + chosenGlobalWatermark + " < " + this.globalWatermarkMs());
    }

    public synchronized long currentWatermark() {
        return this.globalWatermarkMs();
    }

    public synchronized scala.collection.immutable.Map<UUID, Option<Object>> watermarkMap() {
        return this.operatorToWatermarkMap().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ long $anonfun$updateWatermark$3(Option x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    /*
     * WARNING - void declaration
     */
    public WatermarkTracker(MultipleWatermarkPolicy policy, LogicalPlan initialPlan) {
        void var3_3;
        this.policy = policy;
        Logging.$init$((Logging)this);
        HashMap map = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq watermarkOperators = initialPlan.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermark) {
                    EventTimeWatermark eventTimeWatermark = (EventTimeWatermark)A1;
                    return (B1)eventTimeWatermark;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof EventTimeWatermark;
            }
        });
        watermarkOperators.foreach((Function1 & Serializable)op -> map.put((Object)op.nodeId(), (Object)None$.MODULE$));
        this.operatorToWatermarkMap = var3_3;
        this.globalWatermarkMs = 0L;
    }
}

