/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.CommitLog;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\u000e\u001c\u0001)B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\tC\u0003K\u0001\u0011\u00051\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\re\u0003\u0001\u0015!\u0003T\u0011\u001dQ\u0006A1A\u0005\nmCa\u0001\u0018\u0001!\u0002\u0013A\u0004bB/\u0001\u0005\u0004%Ia\u0017\u0005\u0007=\u0002\u0001\u000b\u0011\u0002\u001d\t\u000f}\u0003!\u0019!C\u0005A\"1A\r\u0001Q\u0001\n\u0005Dq!\u001a\u0001C\u0002\u0013%1\f\u0003\u0004g\u0001\u0001\u0006I\u0001\u000f\u0005\bO\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019A\u0007\u0001)A\u0005q!A\u0011\u000e\u0001EC\u0002\u0013%!\u000eC\u0003o\u0001\u0011Eq\u000eC\u0004v\u0001\t\u0007I\u0011\u0003<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c\t\u0011s\n]3sCR|'o\u0015;bi\u0016lU\r^1eCR\fgK\r$jY\u0016l\u0015M\\1hKJT!\u0001H\u000f\u0002\u000bM$\u0018\r^3\u000b\u0005yy\u0012!C:ue\u0016\fW.\u001b8h\u0015\t\u0001\u0013%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g!\t\u0011T'D\u00014\u0015\t!4%\u0001\u0005j]R,'O\\1m\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0002%\rDWmY6q_&tG\u000fT8dCRLwN\u001c\t\u0003syj\u0011A\u000f\u0006\u0003wq\n!AZ:\u000b\u0005u*\u0013A\u00025bI>|\u0007/\u0003\u0002@u\t!\u0001+\u0019;i\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\t\u00115)D\u0001\"\u0013\t!\u0015E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\tti\u0006$Xm\u0015;pe\u0016<&/\u001b;feB\u0011q\tS\u0007\u0002;%\u0011\u0011*\b\u0002\u0011'R\fG/Z*u_J,wK]5uKJ\fa\u0001P5oSRtD\u0003\u0002'O\u001fB\u0003\"!\u0014\u0001\u000e\u0003mAQa\u000e\u0003A\u0002aBQ\u0001\u0011\u0003A\u0002\u0005CQ!\u0012\u0003A\u0002\u0019\u000b!\u0002[1e_>\u00048i\u001c8g+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,=\u0003\u0011\u0019wN\u001c4\n\u0005a+&!D\"p]\u001aLw-\u001e:bi&|g.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0013aE:uCR,7\t[3dWB|\u0017N\u001c;QCRDW#\u0001\u001d\u0002)M$\u0018\r^3DQ\u0016\u001c7\u000e]8j]R\u0004\u0016\r\u001e5!\u00035\u0019H/\u0019;f\u001fBLE\rU1uQ\u0006q1\u000f^1uK>\u0003\u0018\n\u001a)bi\"\u0004\u0013!C2p[6LG\u000fT8h+\u0005\t\u0007CA$c\u0013\t\u0019WDA\u0005D_6l\u0017\u000e\u001e'pO\u0006Q1m\\7nSRdun\u001a\u0011\u0002\u001fM$\u0018\r^3TG\",W.\u0019)bi\"\f\u0001c\u001d;bi\u0016\u001c6\r[3nCB\u000bG\u000f\u001b\u0011\u0002\u001f5,G/\u00193bi\u0006$\u0015N\u001d)bi\"\f\u0001#\\3uC\u0012\fG/\u0019#jeB\u000bG\u000f\u001b\u0011\u0002\u0005\u0019lW#A6\u0011\u0005\u001dc\u0017BA7\u001e\u0005U\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016l\u0015M\\1hKJ\f1\"[:CCR\u001c\u0007NR5mKR\u0011\u0001o\u001d\t\u0003YEL!A]\u0017\u0003\u000f\t{w\u000e\\3b]\")AO\u0005a\u0001q\u0005!\u0001/\u0019;i\u0003A\u0011\u0017\r^2i\r&dWm\u001d$jYR,'/F\u0001x!\tI\u00040\u0003\u0002zu\tQ\u0001+\u0019;i\r&dG/\u001a:\u0002#\t\fGo\u00195GS2,7OR5mi\u0016\u0014\b%A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0004{\u0006\u0005\u0001C\u0001\u0017\u007f\u0013\tyXF\u0001\u0003M_:<\u0007\"\u0002;\u0016\u0001\u0004A\u0014A\u00059ve\u001e,W*\u001a;bI\u0006$\u0018MR5mKN$\"!a\u0002\u0011\u00071\nI!C\u0002\u0002\f5\u0012A!\u00168ji\u0006!b-\u001b8e)\"\u0014Xm\u001d5pY\u0012\u0014\u0015\r^2i\u0013\u0012$\u0012!`\u0001\u0012I\u0016dW\r^3TG\",W.\u0019$jY\u0016\u001cH\u0003BA\u0004\u0003+Aa!a\u0006\u0019\u0001\u0004i\u0018\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0003M!W\r\\3uK6+G/\u00193bi\u00064\u0015\u000e\\3t)\ri\u0018Q\u0004\u0005\u0007\u0003/I\u0002\u0019A?")
public class OperatorStateMetadataV2FileManager
implements Logging {
    private CheckpointFileManager fm;
    private Configuration hadoopConf;
    private final Path stateCheckpointPath;
    private final Path stateOpIdPath;
    private final CommitLog commitLog;
    private final Path stateSchemaPath;
    private final Path metadataDirPath;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path stateCheckpointPath() {
        return this.stateCheckpointPath;
    }

    private Path stateOpIdPath() {
        return this.stateOpIdPath;
    }

    private CommitLog commitLog() {
        return this.commitLog;
    }

    private Path stateSchemaPath() {
        return this.stateSchemaPath;
    }

    private Path metadataDirPath() {
        return this.metadataDirPath;
    }

    private CheckpointFileManager fm$lzycompute() {
        OperatorStateMetadataV2FileManager operatorStateMetadataV2FileManager = this;
        synchronized (operatorStateMetadataV2FileManager) {
            if (!this.bitmap$0) {
                this.fm = CheckpointFileManager$.MODULE$.create(this.metadataDirPath(), this.hadoopConf());
                this.bitmap$0 = true;
            }
        }
        this.hadoopConf = null;
        return this.fm;
    }

    private CheckpointFileManager fm() {
        if (!this.bitmap$0) {
            return this.fm$lzycompute();
        }
        return this.fm;
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    private long pathToBatchId(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName()));
    }

    public void purgeMetadataFiles() {
        long thresholdBatchId = this.findThresholdBatchId();
        if (thresholdBatchId != 0L) {
            long earliestBatchIdKept = this.deleteMetadataFiles(thresholdBatchId);
            this.deleteSchemaFiles(earliestBatchIdKept - 1L);
            return;
        }
    }

    private long findThresholdBatchId() {
        return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.longArrayOps(this.commitLog().listBatchesOnDisk())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    private void deleteSchemaFiles(long thresholdBatchId) {
        if (thresholdBatchId <= 0L) {
            return;
        }
        Path[] schemaFiles = (Path[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])this.fm().list(this.stateSchemaPath())), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))), (Function1 & Serializable)x$4 -> x$4.getPath(), ClassTag$.MODULE$.apply(Path.class));
        Path[] filesBeforeThreshold = (Path[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])schemaFiles), (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)OperatorStateMetadataV2FileManager.$anonfun$deleteSchemaFiles$2(thresholdBatchId, path)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filesBeforeThreshold), (Function1 & Serializable)path -> {
            OperatorStateMetadataV2FileManager.$anonfun$deleteSchemaFiles$5(this, path);
            return BoxedUnit.UNIT;
        });
    }

    private long deleteMetadataFiles(long thresholdBatchId) {
        FileStatus[] metadataFiles = this.fm().list(this.metadataDirPath(), this.batchFilesFilter());
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles))) {
            return -1L;
        }
        long[] sortedBatchIds = (long[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.longArrayOps((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)file -> BoxesRunTime.boxToLong((long)this.pathToBatchId(file.getPath())), (ClassTag)ClassTag$.MODULE$.Long())), (Function1)(JFunction1.mcZJ.sp & Serializable)x$6 -> x$6 <= thresholdBatchId)), (Ordering)Ordering.Long$.MODULE$);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.longArrayOps(sortedBatchIds))) {
            return -1L;
        }
        long latestBatchId = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(sortedBatchIds)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])metadataFiles), (Function1 & Serializable)batchFile -> {
            OperatorStateMetadataV2FileManager.$anonfun$deleteMetadataFiles$3(this, latestBatchId, batchFile);
            return BoxedUnit.UNIT;
        });
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$deleteSchemaFiles$2(long thresholdBatchId$1, Path path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])path.getName().split("_")))))).toOption().exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 <= thresholdBatchId$1);
    }

    public static final /* synthetic */ void $anonfun$deleteSchemaFiles$5(OperatorStateMetadataV2FileManager $this, Path path) {
        $this.fm().delete(path);
    }

    public static final /* synthetic */ void $anonfun$deleteMetadataFiles$3(OperatorStateMetadataV2FileManager $this, long latestBatchId$1, FileStatus batchFile) {
        long batchId = $this.pathToBatchId(batchFile.getPath());
        if (batchId < latestBatchId$1) {
            $this.fm().delete(batchFile.getPath());
            return;
        }
    }

    public OperatorStateMetadataV2FileManager(Path checkpointLocation, SparkSession sparkSession, StateStoreWriter stateStoreWriter) {
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.stateCheckpointPath = new Path(checkpointLocation, "state");
        this.stateOpIdPath = new Path(this.stateCheckpointPath(), Long.toString(stateStoreWriter.getStateInfo().operatorId()));
        this.commitLog = new CommitLog(sparkSession, new Path(checkpointLocation, "commits").toString());
        this.stateSchemaPath = stateStoreWriter.stateSchemaDirPath(stateStoreWriter.stateSchemaDirPath$default$1());
        this.metadataDirPath = OperatorStateMetadataV2$.MODULE$.metadataDirPath(this.stateOpIdPath());
        this.batchFilesFilter = path -> this.isBatchFile(path);
    }
}

