/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;
import java.util.List;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.EncryptedMessageWithHeader;
import org.apache.spark.network.protocol.Message;

@ChannelHandler.Sharable
public final class SslMessageEncoder
extends MessageToMessageEncoder<Message> {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(SslMessageEncoder.class);
    public static final SslMessageEncoder INSTANCE = new SslMessageEncoder();

    private SslMessageEncoder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode(ChannelHandlerContext ctx, Message in, List<Object> out) throws Exception {
        Object body = null;
        long bodyLength = 0L;
        boolean isBodyInFrame = false;
        if (in.body() != null) {
            try {
                bodyLength = in.body().size();
                body = in.body().convertToNettyForSsl();
                isBodyInFrame = in.isBodyInFrame();
            }
            catch (Exception e) {
                in.body().release();
                if (!(in instanceof AbstractResponseMessage)) {
                    throw e;
                }
                AbstractResponseMessage resp = (AbstractResponseMessage)in;
                String error = e.getMessage() != null ? e.getMessage() : "null";
                logger.error("Error processing {} for client {}", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.MESSAGE$.MODULE$, (Object)in), MDC.of((LogKey)LogKeys.HOST_PORT$.MODULE$, (Object)ctx.channel().remoteAddress())});
                this.encode(ctx, resp.createFailureResponse(error), out);
                return;
            }
        }
        Message.Type msgType = in.type();
        int headerLength = 8 + msgType.encodedLength() + in.encodedLength();
        long frameLength = (long)headerLength + (isBodyInFrame ? bodyLength : 0L);
        ByteBuf header = ctx.alloc().buffer(headerLength);
        header.writeLong(frameLength);
        msgType.encode(header);
        in.encode(header);
        assert (header.writableBytes() == 0);
        if (body != null && bodyLength > 0L) {
            if (body instanceof ByteBuf) {
                ByteBuf byteBuf = (ByteBuf)body;
                out.add(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, byteBuf}));
                return;
            } else {
                if (!(body instanceof InputStream) && !(body instanceof ChunkedStream)) throw new IllegalArgumentException("Body must be a ByteBuf, ChunkedStream or an InputStream");
                out.add(new EncryptedMessageWithHeader(in.body(), header, body, bodyLength));
            }
            return;
        } else {
            out.add(header);
        }
    }
}

