/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.kvstore;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.spark.annotation.Private;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreSerializer;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.RocksDBIterator;
import org.apache.spark.util.kvstore.RocksDBTypeInfo;
import org.apache.spark.util.kvstore.UnsupportedStoreVersionException;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Throwables;

@Private
public class RocksDB
implements KVStore {
    @VisibleForTesting
    static final long STORE_VERSION = 1L;
    @VisibleForTesting
    static final byte[] STORE_VERSION_KEY;
    private static final byte[] METADATA_KEY;
    private static final byte[] TYPE_ALIASES_KEY;
    private static final BloomFilter fullFilter;
    private static final BlockBasedTableConfig tableFormatConfig;
    private static final Options dbOptions;
    private static final WriteOptions writeOptions;
    private final AtomicReference<org.rocksdb.RocksDB> _db;
    final KVStoreSerializer serializer;
    private final ConcurrentMap<String, byte[]> typeAliases;
    private final ConcurrentMap<Class<?>, RocksDBTypeInfo> types;
    private final ConcurrentLinkedQueue<Reference<RocksDBIterator<?>>> iteratorTracker;

    public RocksDB(File path) throws Exception {
        this(path, new KVStoreSerializer());
    }

    public RocksDB(File path, KVStoreSerializer serializer) throws Exception {
        Map<Object, Object> aliases;
        this.serializer = serializer;
        this.types = new ConcurrentHashMap();
        this._db = new AtomicReference<org.rocksdb.RocksDB>(org.rocksdb.RocksDB.open((Options)dbOptions, (String)path.toString()));
        byte[] versionData = this.db().get(STORE_VERSION_KEY);
        if (versionData != null) {
            long version = serializer.deserializeLong(versionData);
            if (version != 1L) {
                this.close();
                throw new UnsupportedStoreVersionException();
            }
        } else {
            this.db().put(STORE_VERSION_KEY, serializer.serialize(1L));
        }
        try {
            aliases = this.get((byte[])RocksDB.TYPE_ALIASES_KEY, TypeAliases.class).aliases;
        }
        catch (NoSuchElementException e) {
            aliases = new HashMap();
        }
        this.typeAliases = new ConcurrentHashMap<String, byte[]>(aliases);
        this.iteratorTracker = new ConcurrentLinkedQueue();
    }

    @Override
    public <T> T getMetadata(Class<T> klass) throws Exception {
        try {
            return this.get(METADATA_KEY, klass);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    @Override
    public void setMetadata(Object value) throws Exception {
        if (value != null) {
            this.put(METADATA_KEY, value);
        } else {
            this.db().delete(METADATA_KEY);
        }
    }

    <T> T get(byte[] key, Class<T> klass) throws Exception {
        byte[] data = this.db().get(key);
        if (data == null) {
            throw new NoSuchElementException(new String(key, StandardCharsets.UTF_8));
        }
        return this.serializer.deserialize(data, klass);
    }

    private void put(byte[] key, Object value) throws Exception {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Null values are not allowed.");
        this.db().put(key, this.serializer.serialize(value));
    }

    @Override
    public <T> T read(Class<T> klass, Object naturalKey) throws Exception {
        Preconditions.checkArgument((naturalKey != null ? 1 : 0) != 0, (Object)"Null keys are not allowed.");
        byte[] key = this.getTypeInfo(klass).naturalIndex().start(null, naturalKey);
        return this.get(key, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object value) throws Exception {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Null values are not allowed.");
        RocksDBTypeInfo ti = this.getTypeInfo(value.getClass());
        byte[] data = this.serializer.serialize(value);
        RocksDBTypeInfo rocksDBTypeInfo = ti;
        synchronized (rocksDBTypeInfo) {
            try (WriteBatch writeBatch = new WriteBatch();){
                this.updateBatch(writeBatch, value, data, value.getClass(), ti.naturalIndex(), ti.indices());
                this.db().write(writeOptions, writeBatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAll(List<?> values) throws Exception {
        Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0, (Object)"Non-empty values required.");
        for (Map.Entry<Class, List<Object>> entry : values.stream().collect(Collectors.groupingBy(Object::getClass)).entrySet()) {
            RocksDBTypeInfo ti;
            Iterator<Object> valueIter = entry.getValue().iterator();
            ArrayList<byte[]> list = new ArrayList<byte[]>(entry.getValue().size());
            for (Object value : entry.getValue()) {
                list.add(this.serializer.serialize(value));
            }
            Iterator serializedValueIter = list.iterator();
            Class klass = entry.getKey();
            RocksDBTypeInfo rocksDBTypeInfo = ti = this.getTypeInfo(klass);
            synchronized (rocksDBTypeInfo) {
                RocksDBTypeInfo.Index naturalIndex = ti.naturalIndex();
                Collection<RocksDBTypeInfo.Index> indices = ti.indices();
                try (WriteBatch writeBatch = new WriteBatch();){
                    while (valueIter.hasNext()) {
                        assert (serializedValueIter.hasNext());
                        this.updateBatch(writeBatch, valueIter.next(), (byte[])serializedValueIter.next(), klass, naturalIndex, indices);
                    }
                    this.db().write(writeOptions, writeBatch);
                }
            }
        }
    }

    private void updateBatch(WriteBatch batch, Object value, byte[] data, Class<?> klass, RocksDBTypeInfo.Index naturalIndex, Collection<RocksDBTypeInfo.Index> indices) throws Exception {
        Object existing;
        try {
            existing = this.get(naturalIndex.entityKey(null, value), klass);
        }
        catch (NoSuchElementException e) {
            existing = null;
        }
        PrefixCache cache = new PrefixCache(value);
        byte[] naturalKey = naturalIndex.toKey(naturalIndex.getValue(value));
        for (RocksDBTypeInfo.Index idx : indices) {
            byte[] prefix = cache.getPrefix(idx);
            idx.add(batch, value, existing, data, naturalKey, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Class<?> type, Object naturalKey) throws Exception {
        Preconditions.checkArgument((naturalKey != null ? 1 : 0) != 0, (Object)"Null keys are not allowed.");
        try (WriteBatch writeBatch = new WriteBatch();){
            RocksDBTypeInfo ti = this.getTypeInfo(type);
            byte[] key = ti.naturalIndex().start(null, naturalKey);
            RocksDBTypeInfo rocksDBTypeInfo = ti;
            synchronized (rocksDBTypeInfo) {
                byte[] data = this.db().get(key);
                if (data != null) {
                    Object existing = this.serializer.deserialize(data, type);
                    PrefixCache cache = new PrefixCache(existing);
                    byte[] keyBytes = ti.naturalIndex().toKey(ti.naturalIndex().getValue(existing));
                    for (RocksDBTypeInfo.Index idx : ti.indices()) {
                        idx.remove(writeBatch, existing, keyBytes, cache.getPrefix(idx));
                    }
                    this.db().write(writeOptions, writeBatch);
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public <T> KVStoreView<T> view(final Class<T> type) throws Exception {
        return new KVStoreView<T>(){

            @Override
            public Iterator<T> iterator() {
                try {
                    RocksDBIterator it = new RocksDBIterator(type, RocksDB.this, this);
                    RocksDB.this.iteratorTracker.add(new WeakReference(it));
                    return it;
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public <T> boolean removeAllByIndexValues(Class<T> klass, String index, Collection<?> indexValues) throws Exception {
        RocksDBTypeInfo.Index naturalIndex = this.getTypeInfo(klass).naturalIndex();
        boolean removed = false;
        KVStoreView<T> view = this.view(klass).index(index);
        for (Object indexValue : indexValues) {
            KVStoreIterator<T> iterator = view.first(indexValue).last(indexValue).closeableIterator();
            try {
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    Object itemKey = naturalIndex.getValue(value);
                    this.delete(klass, itemKey);
                    removed = true;
                }
            }
            finally {
                if (iterator == null) continue;
                iterator.close();
            }
        }
        return removed;
    }

    @Override
    public long count(Class<?> type) throws Exception {
        RocksDBTypeInfo.Index idx = this.getTypeInfo(type).naturalIndex();
        return idx.getCount(idx.end(null));
    }

    @Override
    public long count(Class<?> type, String index, Object indexedValue) throws Exception {
        RocksDBTypeInfo.Index idx = this.getTypeInfo(type).index(index);
        return idx.getCount(idx.end(null, indexedValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AtomicReference<org.rocksdb.RocksDB> atomicReference = this._db;
        synchronized (atomicReference) {
            org.rocksdb.RocksDB _db = this._db.getAndSet(null);
            if (_db == null) {
                return;
            }
            try {
                if (this.iteratorTracker != null) {
                    for (Reference<RocksDBIterator<?>> ref : this.iteratorTracker) {
                        RocksDBIterator<?> it = ref.get();
                        if (it == null) continue;
                        it.close();
                    }
                }
                _db.close();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeIterator(RocksIterator it) {
        this.notifyIteratorClosed(it);
        AtomicReference<org.rocksdb.RocksDB> atomicReference = this._db;
        synchronized (atomicReference) {
            org.rocksdb.RocksDB _db = this._db.get();
            if (_db != null) {
                it.close();
            }
        }
    }

    void notifyIteratorClosed(RocksIterator rocksIterator) {
        this.iteratorTracker.removeIf(ref -> {
            RocksDBIterator rocksDBIterator = (RocksDBIterator)ref.get();
            return rocksDBIterator != null && rocksIterator.equals(rocksDBIterator.internalIterator());
        });
    }

    RocksDBTypeInfo getTypeInfo(Class<?> type) throws Exception {
        RocksDBTypeInfo tmp;
        RocksDBTypeInfo ti = (RocksDBTypeInfo)this.types.get(type);
        if (ti == null && (ti = this.types.putIfAbsent(type, tmp = new RocksDBTypeInfo(this, type, this.getTypeAlias(type)))) == null) {
            ti = tmp;
        }
        return ti;
    }

    org.rocksdb.RocksDB db() {
        org.rocksdb.RocksDB _db = this._db.get();
        if (_db == null) {
            throw new IllegalStateException("DB is closed.");
        }
        return _db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTypeAlias(Class<?> klass) throws Exception {
        byte[] alias = (byte[])this.typeAliases.get(klass.getName());
        if (alias == null) {
            ConcurrentMap<String, byte[]> concurrentMap = this.typeAliases;
            synchronized (concurrentMap) {
                byte[] tmp = String.valueOf(this.typeAliases.size()).getBytes(StandardCharsets.UTF_8);
                alias = this.typeAliases.putIfAbsent(klass.getName(), tmp);
                if (alias == null) {
                    alias = tmp;
                    this.put(TYPE_ALIASES_KEY, new TypeAliases(this.typeAliases));
                }
            }
        }
        return alias;
    }

    static {
        org.rocksdb.RocksDB.loadLibrary();
        STORE_VERSION_KEY = "__version__".getBytes(StandardCharsets.UTF_8);
        METADATA_KEY = "__meta__".getBytes(StandardCharsets.UTF_8);
        TYPE_ALIASES_KEY = "__types__".getBytes(StandardCharsets.UTF_8);
        fullFilter = new BloomFilter(10.0, false);
        tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
        dbOptions = new Options().setCreateIfMissing(true).setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION).setCompressionType(CompressionType.LZ4_COMPRESSION).setTableFormatConfig((TableFormatConfig)tableFormatConfig);
        writeOptions = new WriteOptions().setSync(false);
    }

    public static class TypeAliases {
        public Map<String, byte[]> aliases;

        TypeAliases(Map<String, byte[]> aliases) {
            this.aliases = aliases;
        }

        TypeAliases() {
            this(null);
        }
    }

    private static class PrefixCache {
        private final Object entity;
        private final Map<RocksDBTypeInfo.Index, byte[]> prefixes;

        PrefixCache(Object entity) {
            this.entity = entity;
            this.prefixes = new HashMap<RocksDBTypeInfo.Index, byte[]>();
        }

        byte[] getPrefix(RocksDBTypeInfo.Index idx) throws Exception {
            byte[] prefix = null;
            if (idx.isChild() && (prefix = this.prefixes.get(idx.parent())) == null) {
                prefix = idx.parent().childPrefix(idx.parent().getValue(this.entity));
                this.prefixes.put(idx.parent(), prefix);
            }
            return prefix;
        }
    }
}

