/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.support;

import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionExecutorNotFoundException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.service.GenericConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.builder.support.TextToTargetStateResolver;
import org.springframework.webflow.engine.builder.support.TextToTransitionCriteria;
import org.springframework.webflow.validation.ValidationHintResolver;

public class FlowBuilderContextImpl
implements FlowBuilderContext {
    private String flowId;
    private AttributeMap<Object> flowAttributes;
    private FlowDefinitionLocator flowDefinitionLocator;
    private FlowBuilderServices flowBuilderServices;
    private ConversionService conversionService;

    public FlowBuilderContextImpl(String flowId, AttributeMap<Object> flowAttributes, FlowDefinitionLocator flowDefinitionLocator, FlowBuilderServices flowBuilderServices) {
        Assert.hasText((String)flowId, (String)"The flow id is required");
        Assert.notNull((Object)flowDefinitionLocator, (String)"The flow definition locator is required");
        Assert.notNull((Object)flowBuilderServices, (String)"The flow builder services holder is required");
        this.flowId = flowId;
        this.initFlowAttributes(flowAttributes);
        this.flowDefinitionLocator = flowDefinitionLocator;
        this.flowBuilderServices = flowBuilderServices;
        this.conversionService = this.createConversionService();
    }

    public FlowBuilderServices getFlowBuilderServices() {
        return this.flowBuilderServices;
    }

    @Override
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    public AttributeMap<Object> getFlowAttributes() {
        return this.flowAttributes;
    }

    @Override
    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.flowBuilderServices.getFlowArtifactFactory();
    }

    @Override
    public FlowDefinitionLocator getFlowDefinitionLocator() {
        return this.flowDefinitionLocator;
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public ViewFactoryCreator getViewFactoryCreator() {
        return this.flowBuilderServices.getViewFactoryCreator();
    }

    @Override
    public ExpressionParser getExpressionParser() {
        return this.flowBuilderServices.getExpressionParser();
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.flowBuilderServices.getApplicationContext();
    }

    @Override
    public Validator getValidator() {
        return this.flowBuilderServices.getValidator();
    }

    @Override
    public ValidationHintResolver getValidationHintResolver() {
        return this.flowBuilderServices.getValidationHintResolver();
    }

    protected ConversionService createConversionService() {
        GenericConversionService service = new GenericConversionService(this.getFlowBuilderServices().getConversionService().getDelegateConversionService());
        service.addConverter((Converter)new TextToTransitionCriteria(this));
        service.addConverter((Converter)new TextToTargetStateResolver(this));
        service.setParent((ConversionService)new ParentConversionServiceProxy());
        return service;
    }

    private void initFlowAttributes(AttributeMap<Object> flowAttributes) {
        this.flowAttributes = flowAttributes != null ? flowAttributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    private class ParentConversionServiceProxy
    implements ConversionService {
        private ParentConversionServiceProxy() {
        }

        public Object executeConversion(Object source, Class<?> targetClass) throws ConversionException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().executeConversion(source, targetClass);
        }

        public Object executeConversion(String converterId, Object source, Class<?> targetClass) {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().executeConversion(converterId, source, targetClass);
        }

        public ConversionExecutor getConversionExecutor(Class<?> sourceClass, Class<?> targetClass) throws ConversionExecutionException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getConversionExecutor(sourceClass, targetClass);
        }

        public ConversionExecutor getConversionExecutor(String id, Class<?> sourceClass, Class<?> targetClass) throws ConversionExecutorNotFoundException {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getConversionExecutor(id, sourceClass, targetClass);
        }

        public Class<?> getClassForAlias(String name) {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getClassForAlias(name);
        }

        public org.springframework.core.convert.ConversionService getDelegateConversionService() {
            return FlowBuilderContextImpl.this.getFlowBuilderServices().getConversionService().getDelegateConversionService();
        }
    }
}

