/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.event.RemoteCommitProvider;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.syncope.core.persistence.api.dao.PersistenceInfoDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JPAPersistenceInfoDAO
extends AbstractDAO<Entity>
implements PersistenceInfoDAO {
    public Map<String, Object> info() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        OpenJPAEntityManagerFactorySPI emfspi = (OpenJPAEntityManagerFactorySPI)OpenJPAPersistence.cast((EntityManagerFactory)this.entityManagerFactory());
        OpenJPAConfiguration conf = emfspi.getConfiguration();
        Map properties = emfspi.getProperties();
        result.put("vendor", properties.get("VendorName"));
        result.put("version", properties.get("VersionNumber"));
        result.put("platform", properties.get("Platform"));
        LinkedHashMap<String, Object> remoteCommitProvider = new LinkedHashMap<String, Object>();
        result.put("remoteCommitProvider", remoteCommitProvider);
        RemoteCommitEventManager rcem = conf.getRemoteCommitEventManager();
        remoteCommitProvider.put("remoteEventsEnabled", rcem.areRemoteEventsEnabled());
        remoteCommitProvider.put("transmitPersistedObjectIds", rcem.getTransmitPersistedObjectIds());
        remoteCommitProvider.put("failFast", rcem.isFailFast());
        RemoteCommitProvider rcp = rcem.getRemoteCommitProvider();
        ArrayList addresses = new ArrayList();
        if (rcp instanceof TCPRemoteCommitProvider) {
            try {
                Field addressesField = ReflectionUtils.findField(TCPRemoteCommitProvider.class, (String)"_addresses");
                addressesField.setAccessible(true);
                Class hostClass = ClassUtils.forName((String)"org.apache.openjpa.event.TCPRemoteCommitProvider$HostAddress", (ClassLoader)ClassUtils.getDefaultClassLoader());
                Field addressField = ReflectionUtils.findField((Class)hostClass, (String)"_address");
                addressField.setAccessible(true);
                Field portField = ReflectionUtils.findField((Class)hostClass, (String)"_port");
                portField.setAccessible(true);
                Field isAvailableField = ReflectionUtils.findField((Class)hostClass, (String)"_isAvailable");
                isAvailableField.setAccessible(true);
                List hosts = (List)ReflectionUtils.getField((Field)addressesField, (Object)rcp);
                hosts.forEach(host -> {
                    InetAddress address = (InetAddress)ReflectionUtils.getField((Field)addressField, (Object)host);
                    Integer port = (Integer)ReflectionUtils.getField((Field)portField, (Object)host);
                    Boolean isAvailable = (Boolean)ReflectionUtils.getField((Field)isAvailableField, (Object)host);
                    addresses.add(Triple.of((Object)address.getHostAddress(), (Object)port, (Object)isAvailable));
                });
            }
            catch (Exception e) {
                LOG.error("Could not fetch information about TCPRemoteCommitProvider", (Throwable)e);
            }
        }
        remoteCommitProvider.put("addresses", addresses.stream().map(address -> {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("ip", address.getLeft());
            map.put("port", address.getMiddle());
            map.put("available", address.getRight());
            return map;
        }).collect(Collectors.toList()));
        return result;
    }
}

