/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.graphql;

import graphql.GraphQL;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.graphql.DefaultGraphQlTagsProvider;
import org.springframework.boot.actuate.metrics.graphql.GraphQlMetricsInstrumentation;
import org.springframework.boot.actuate.metrics.graphql.GraphQlTagsContributor;
import org.springframework.boot.actuate.metrics.graphql.GraphQlTagsProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.execution.GraphQlSource;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnBean(value={MeterRegistry.class})
@ConditionalOnClass(value={GraphQL.class, GraphQlSource.class})
@EnableConfigurationProperties(value={MetricsProperties.class})
public class GraphQlMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GraphQlTagsProvider.class})
    public DefaultGraphQlTagsProvider graphQlTagsProvider(ObjectProvider<GraphQlTagsContributor> contributors) {
        return new DefaultGraphQlTagsProvider(contributors.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public GraphQlMetricsInstrumentation graphQlMetricsInstrumentation(MeterRegistry meterRegistry, GraphQlTagsProvider tagsProvider, MetricsProperties properties) {
        return new GraphQlMetricsInstrumentation(meterRegistry, tagsProvider, (AutoTimer)properties.getGraphql().getAutotime());
    }
}

