/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SimpleKafkaListenerEndpoint<K, V>
implements KafkaListenerEndpoint,
InitializingBean {
    protected String id;
    protected String groupId;
    protected Collection<String> topics;
    protected Pattern topicPattern;
    protected Collection<TopicPartitionOffset> topicPartitions;
    protected String clientIdPrefix;
    protected Integer concurrency;
    protected Properties consumerProperties;
    protected boolean splitIterables = true;
    protected GenericMessageListener<ConsumerRecord<K, V>> messageListener;

    public void setMessageListener(GenericMessageListener<ConsumerRecord<K, V>> messageListener) {
        this.messageListener = messageListener;
    }

    public GenericMessageListener<ConsumerRecord<K, V>> getMessageListener() {
        return this.messageListener;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroup() {
        return null;
    }

    public Collection<String> getTopics() {
        return this.topics != null ? this.topics : Collections.emptyList();
    }

    public void setTopics(Collection<String> topics) {
        this.topics = topics;
    }

    public TopicPartitionOffset[] getTopicPartitionsToAssign() {
        return this.topicPartitions == null ? null : this.topicPartitions.toArray(new TopicPartitionOffset[0]);
    }

    public void setTopicPartitions(Collection<TopicPartitionOffset> topicPartitions) {
        this.topicPartitions = topicPartitions;
    }

    public Pattern getTopicPattern() {
        return this.topicPattern;
    }

    public void setTopicPattern(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    public String getClientIdPrefix() {
        return this.clientIdPrefix;
    }

    public void setClientIdPrefix(String clientIdPrefix) {
        this.clientIdPrefix = clientIdPrefix;
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public Boolean getAutoStartup() {
        return null;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    public void setupListenerContainer(MessageListenerContainer listenerContainer, MessageConverter messageConverter) {
        GenericMessageListener<ConsumerRecord<K, V>> messageListener = this.getMessageListener();
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + this + "] must provide a non null message listener");
        listenerContainer.setupMessageListener(messageListener);
    }

    public boolean isSplitIterables() {
        return this.splitIterables;
    }

    public void setSplitIterables(boolean splitIterables) {
        this.splitIterables = splitIterables;
    }

    public void afterPropertiesSet() throws Exception {
        boolean topicsEmpty = this.getTopics().isEmpty();
        boolean topicPartitionsEmpty = ObjectUtils.isEmpty((Object[])this.getTopicPartitionsToAssign());
        if (!topicsEmpty && !topicPartitionsEmpty) {
            throw new IllegalStateException("Topics or topicPartitions must be provided but not both for " + this);
        }
        if (!(this.topicPattern == null || topicsEmpty && topicPartitionsEmpty)) {
            throw new IllegalStateException("Only one of topics, topicPartitions or topicPattern must are allowed for " + this);
        }
        if (this.topicPattern == null && topicsEmpty && topicPartitionsEmpty) {
            throw new IllegalStateException("At least one of topics, topicPartitions or topicPattern must be provided for " + this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "] topics=" + this.topics + "' | topicPattern='" + this.topicPattern + "'' | topicPartitions='" + this.topicPartitions + "' | messageListener='" + this.messageListener + "'";
    }
}

