/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.wicket.markup.html.list.ConnConfPropertyListView;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.ResourceModel;

public abstract class AbstractConnConfPanel<T extends EntityTO>
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = -2025535531121434050L;
    protected LoadableDetachableModel<List<ConnConfProperty>> model;
    protected final WebMarkupContainer propertiesContainer;
    protected final AjaxButton check;
    protected final T modelObject;

    public AbstractConnConfPanel(T model) {
        this.modelObject = model;
        this.setOutputMarkupId(true);
        this.propertiesContainer = new WebMarkupContainer("connectorPropertiesContainer");
        this.propertiesContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.propertiesContainer});
        this.check = new IndicatingAjaxButton("check", (IModel)new ResourceModel("check")){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onSubmit(AjaxRequestTarget target) {
                Pair<Boolean, String> result = AbstractConnConfPanel.this.check(target);
                if (((Boolean)result.getLeft()).booleanValue()) {
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                } else {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(this.getString("error_connection") + ": " + (String)result.getRight())));
                }
                ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        this.propertiesContainer.add(new Component[]{this.check});
    }

    protected void setConfPropertyListView(IModel<List<ConnConfProperty>> model, boolean withOverridable) {
        this.propertiesContainer.addOrReplace(new Component[]{new ConnConfPropertyListView("connectorProperties", model, withOverridable).setOutputMarkupId(true)});
    }

    protected abstract Pair<Boolean, String> check(AjaxRequestTarget var1);

    protected abstract List<ConnConfProperty> getConnProperties(T var1);

    public boolean evaluate() {
        return this.model != null && this.model.getObject() != null && !((List)this.model.getObject()).isEmpty();
    }
}

