/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CancelEventDefinition;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Transaction;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class EndEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List endEvents = process.findFlowElementsOfType(EndEvent.class);
        for (EndEvent endEvent : endEvents) {
            FlowElementsContainer parent;
            EventDefinition eventDefinition;
            if (endEvent.getEventDefinitions() == null || endEvent.getEventDefinitions().isEmpty() || !((eventDefinition = (EventDefinition)endEvent.getEventDefinitions().get(0)) instanceof CancelEventDefinition) || (parent = process.findParent((FlowElement)endEvent)) instanceof Transaction) continue;
            this.addError(errors, "flowable-end-event-cancel-only-inside-transaction", process, (BaseElement)endEvent, "end event with cancelEventDefinition only supported inside transaction subprocess");
        }
    }
}

