/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.util;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcRequestSupport {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcRequestSupport.class);
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final TicketRegistrySupport ticketRegistrySupport;

    public static Optional<Long> getOidcMaxAgeFromAuthorizationRequest(WebContext context) {
        return (Optional)FunctionUtils.doUnchecked(() -> {
            URIBuilder builderContext = new URIBuilder(context.getFullRequestURL());
            return builderContext.getQueryParams().stream().filter(p -> "max_age".equals(p.getName())).map(p -> Optional.of(p.getValue())).findFirst().orElseGet(() -> context.getRequestParameter("max_age")).map(param -> {
                long maxAge = NumberUtils.toLong((String)param, (long)-1L);
                return Optional.of(maxAge);
            }).orElseGet(Optional::empty);
        });
    }

    public static Optional<UserProfile> isAuthenticationProfileAvailable(JEEContext context, SessionStore sessionStore) {
        ProfileManager manager = new ProfileManager((WebContext)context, sessionStore);
        return manager.getProfile();
    }

    public static String getRedirectUrlWithError(String originalRedirectUrl, String errorCode, WebContext webContext) {
        return (String)FunctionUtils.doUnchecked(() -> {
            URIBuilder uriBuilder = new URIBuilder(originalRedirectUrl).addParameter("error", errorCode);
            webContext.getRequestParameter("state").ifPresent(st -> uriBuilder.addParameter("state", st));
            return uriBuilder.build().toASCIIString();
        });
    }

    public static String removeOidcPromptFromAuthorizationRequest(String url, String prompt) {
        return (String)FunctionUtils.doUnchecked(() -> {
            URIBuilder uriBuilder = new URIBuilder(url);
            List newParams = uriBuilder.getQueryParams().stream().filter(p -> !"prompt".equals(p.getName()) || !p.getValue().equalsIgnoreCase(prompt)).collect(Collectors.toList());
            return uriBuilder.removeQuery().addParameters(newParams).build().toASCIIString();
        });
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, ZonedDateTime authenticationDate) {
        long authTime;
        long now;
        long diffInSeconds;
        Optional<Long> maxAge = OidcRequestSupport.getOidcMaxAgeFromAuthorizationRequest(context);
        if (maxAge.isPresent() && maxAge.get() > 0L && (diffInSeconds = (now = ZonedDateTime.now(ZoneOffset.UTC).toEpochSecond()) - (authTime = authenticationDate.toEpochSecond())) > maxAge.get()) {
            LOGGER.info("Authentication is too old: [{}] and was created [{}] seconds ago.", (Object)authTime, (Object)diffInSeconds);
            return true;
        }
        return false;
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, Authentication authentication) {
        return OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, authentication.getAuthenticationDate());
    }

    public static boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context, BasicUserProfile profile) {
        Object authTime = profile.getAttribute("authenticationDate");
        if (authTime == null) {
            authTime = profile.getAuthenticationAttribute("authenticationDate");
        }
        if (authTime == null) {
            return false;
        }
        ZonedDateTime dt = ZonedDateTime.parse(CollectionUtils.toCollection((Object)authTime).iterator().next().toString());
        return OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, dt);
    }

    public boolean isCasAuthenticationOldForMaxAgeAuthorizationRequest(WebContext context) {
        return this.isCasAuthenticationAvailable(context).filter(a -> OidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context, a)).isPresent();
    }

    public Optional<Authentication> isCasAuthenticationAvailable(WebContext context) {
        Authentication authentication;
        String tgtId;
        JEEContext webContext = (JEEContext)context;
        if (webContext != null && StringUtils.isNotBlank((CharSequence)(tgtId = this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(webContext.getNativeRequest()))) && (authentication = this.ticketRegistrySupport.getAuthenticationFrom(tgtId)) != null) {
            return Optional.of(authentication);
        }
        return Optional.empty();
    }

    @Generated
    public OidcRequestSupport(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistrySupport ticketRegistrySupport) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistrySupport = ticketRegistrySupport;
    }
}

