/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.definition;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.factory.ProfileFactory;
import org.pac4j.oauth.config.OAuthConfiguration;

public abstract class OAuthProfileDefinition
extends CommonProfileDefinition {
    public OAuthProfileDefinition() {
    }

    public OAuthProfileDefinition(ProfileFactory profileFactory) {
        super(profileFactory);
    }

    public Verb getProfileVerb() {
        return Verb.GET;
    }

    public abstract String getProfileUrl(Token var1, OAuthConfiguration var2);

    public abstract CommonProfile extractUserProfile(String var1);

    protected void raiseProfileExtractionJsonError(String body, String missingNode) {
        this.logger.error("Unable to extract user profile as no JSON node '{}' was found in body: {}", (Object)missingNode, (Object)body);
        throw new TechnicalException("No JSON node '" + missingNode + "' to extract user profile from");
    }

    protected void raiseProfileExtractionJsonError(String body) {
        this.logger.error("Unable to extract user profile as no JSON node was found in body: {}", (Object)body);
        throw new TechnicalException("No JSON node to extract user profile from");
    }

    protected void raiseProfileExtractionError(String body) {
        this.logger.error("Unable to extract user profile from body: {}", (Object)body);
        throw new TechnicalException("Unable to extract user profile");
    }
}

