/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption;

import com.google.common.base.Strings;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NewEncryptedID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.encryption.CarriedKeyName;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.opensaml.xmlsec.encryption.XMLEncryptionBuilder;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.RetrievalMethod;
import org.opensaml.xmlsec.signature.XMLSignatureBuilder;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Encrypter
extends org.opensaml.xmlsec.encryption.support.Encrypter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(Encrypter.class);
    private XMLObjectBuilderFactory builderFactory;
    private XMLSignatureBuilder<KeyInfo> keyInfoBuilder;
    private XMLEncryptionBuilder<DataReference> dataReferenceBuilder;
    private XMLEncryptionBuilder<ReferenceList> referenceListBuilder;
    private XMLSignatureBuilder<RetrievalMethod> retrievalMethodBuilder;
    private XMLSignatureBuilder<KeyName> keyNameBuilder;
    private XMLEncryptionBuilder<CarriedKeyName> carriedKeyNameBuilder;
    private IdentifierGenerationStrategy idGenerator;
    private DataEncryptionParameters encParams;
    private List<KeyEncryptionParameters> kekParamsList;
    @Nonnull
    private KeyPlacement keyPlacement = KeyPlacement.PEER;

    public Encrypter(DataEncryptionParameters dataEncParams, List<KeyEncryptionParameters> keyEncParams) {
        this.encParams = dataEncParams;
        this.kekParamsList = keyEncParams;
        this.init();
    }

    public Encrypter(DataEncryptionParameters dataEncParams, KeyEncryptionParameters keyEncParam) {
        ArrayList<KeyEncryptionParameters> keks = new ArrayList<KeyEncryptionParameters>();
        keks.add(keyEncParam);
        this.encParams = dataEncParams;
        this.kekParamsList = keks;
        this.init();
    }

    public Encrypter(DataEncryptionParameters dataEncParams) {
        ArrayList<KeyEncryptionParameters> keks = new ArrayList<KeyEncryptionParameters>();
        this.encParams = dataEncParams;
        this.kekParamsList = keks;
        this.init();
    }

    private void init() {
        this.builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.keyInfoBuilder = (XMLSignatureBuilder)this.builderFactory.ensureBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
        this.dataReferenceBuilder = (XMLEncryptionBuilder)this.builderFactory.ensureBuilder(DataReference.DEFAULT_ELEMENT_NAME);
        this.referenceListBuilder = (XMLEncryptionBuilder)this.builderFactory.ensureBuilder(ReferenceList.DEFAULT_ELEMENT_NAME);
        this.retrievalMethodBuilder = (XMLSignatureBuilder)this.builderFactory.ensureBuilder(RetrievalMethod.DEFAULT_ELEMENT_NAME);
        this.keyNameBuilder = (XMLSignatureBuilder)this.builderFactory.ensureBuilder(KeyName.DEFAULT_ELEMENT_NAME);
        this.carriedKeyNameBuilder = (XMLEncryptionBuilder)this.builderFactory.ensureBuilder(CarriedKeyName.DEFAULT_ELEMENT_NAME);
        this.idGenerator = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.RANDOM);
    }

    public void setIDGenerator(@Nonnull IdentifierGenerationStrategy newIDGenerator) {
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)newIDGenerator, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Nonnull
    public KeyPlacement getKeyPlacement() {
        return this.keyPlacement;
    }

    public void setKeyPlacement(@Nonnull KeyPlacement newKeyPlacement) {
        this.keyPlacement = (KeyPlacement)((Object)Constraint.isNotNull((Object)((Object)newKeyPlacement), (String)"KeyPlacement cannot be null"));
    }

    @Nonnull
    public EncryptedAssertion encrypt(@Nonnull Assertion assertion) throws EncryptionException {
        this.logPreEncryption(assertion, "Assertion");
        return (EncryptedAssertion)this.encrypt(assertion, EncryptedAssertion.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    public EncryptedID encryptAsID(@Nonnull Assertion assertion) throws EncryptionException {
        this.logPreEncryption(assertion, "Assertion (as EncryptedID)");
        return (EncryptedID)this.encrypt(assertion, EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    public EncryptedAttribute encrypt(@Nonnull Attribute attribute) throws EncryptionException {
        this.logPreEncryption(attribute, "Attribute");
        return (EncryptedAttribute)this.encrypt(attribute, EncryptedAttribute.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    public EncryptedID encrypt(@Nonnull NameID nameID) throws EncryptionException {
        this.logPreEncryption(nameID, "NameID");
        return (EncryptedID)this.encrypt(nameID, EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    public EncryptedID encrypt(@Nonnull BaseID baseID) throws EncryptionException {
        this.logPreEncryption(baseID, "BaseID");
        return (EncryptedID)this.encrypt(baseID, EncryptedID.DEFAULT_ELEMENT_NAME);
    }

    @Nonnull
    public NewEncryptedID encrypt(@Nonnull NewID newID) throws EncryptionException {
        this.logPreEncryption(newID, "NewID");
        return (NewEncryptedID)this.encrypt(newID, NewEncryptedID.DEFAULT_ELEMENT_NAME);
    }

    private void logPreEncryption(@Nonnull XMLObject xmlObject, @Nonnull String objectType) {
        if (this.log.isDebugEnabled()) {
            try {
                Element dom = XMLObjectSupport.marshall((XMLObject)xmlObject);
                this.log.debug("{} before encryption:\n{}", (Object)objectType, (Object)SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall {} for logging purposes", (Object)objectType, (Object)e);
            }
        }
    }

    @Nonnull
    private EncryptedElementType encrypt(@Nonnull XMLObject xmlObject, @Nonnull QName encElementName) throws EncryptionException {
        Key encryptionKey;
        this.checkParams(this.encParams, this.kekParamsList);
        EncryptedElementType encElement = (EncryptedElementType)this.builderFactory.ensureBuilder(encElementName).buildObject(encElementName);
        this.checkAndMarshall(encElement);
        Element domNode = encElement.getDOM();
        assert (domNode != null);
        Document ownerDocument = domNode.getOwnerDocument();
        String encryptionAlgorithmURI = this.encParams.getAlgorithm();
        assert (encryptionAlgorithmURI != null);
        Credential encryptionCred = this.encParams.getEncryptionCredential();
        Key key = encryptionKey = encryptionCred != null ? CredentialSupport.extractEncryptionKey((Credential)encryptionCred) : null;
        if (encryptionKey == null) {
            encryptionKey = this.generateEncryptionKey(encryptionAlgorithmURI);
        }
        EncryptedData encryptedData = this.encryptElement(xmlObject, encryptionKey, encryptionAlgorithmURI, false);
        KeyInfoGenerator generator = this.encParams.getKeyInfoGenerator();
        if (generator != null) {
            this.log.debug("Dynamically generating KeyInfo from Credential for EncryptedData using generator: {}", (Object)generator.getClass().getName());
            try {
                encryptedData.setKeyInfo(generator.generate(this.encParams.getEncryptionCredential()));
            }
            catch (SecurityException e) {
                throw new EncryptionException("Error generating EncryptedData KeyInfo", (Exception)((Object)e));
            }
        }
        ArrayList<EncryptedKey> encryptedKeys = new ArrayList<EncryptedKey>();
        if (this.kekParamsList != null && !this.kekParamsList.isEmpty()) {
            encryptedKeys.addAll(this.encryptKey(encryptionKey, this.kekParamsList, ownerDocument));
        }
        return this.processElements(encElement, encryptedData, encryptedKeys);
    }

    @Nonnull
    protected EncryptedElementType processElements(@Nonnull EncryptedElementType encElement, @Nonnull EncryptedData encData, @Nonnull List<EncryptedKey> encKeys) throws EncryptionException {
        if (encData.getID() == null) {
            encData.setID(this.idGenerator.generateIdentifier());
        }
        if (encKeys.isEmpty()) {
            encElement.setEncryptedData(encData);
            return encElement;
        }
        if (encData.getKeyInfo() == null) {
            encData.setKeyInfo((KeyInfo)this.keyInfoBuilder.buildObject());
        }
        for (EncryptedKey encKey : encKeys) {
            if (encKey.getID() != null) continue;
            encKey.setID(this.idGenerator.generateIdentifier());
        }
        switch (this.keyPlacement) {
            case INLINE: {
                return this.placeKeysInline(encElement, encData, encKeys);
            }
            case PEER: {
                return this.placeKeysAsPeers(encElement, encData, encKeys);
            }
        }
        throw new EncryptionException("Unsupported key placement option was specified: " + this.keyPlacement);
    }

    @Nonnull
    protected EncryptedElementType placeKeysInline(@Nonnull EncryptedElementType encElement, @Nonnull EncryptedData encData, @Nonnull List<EncryptedKey> encKeys) {
        this.log.debug("Placing EncryptedKey elements inline inside EncryptedData");
        KeyInfo keyInfo = encData.getKeyInfo();
        if (keyInfo != null) {
            keyInfo.getEncryptedKeys().addAll(encKeys);
        }
        encElement.setEncryptedData(encData);
        return encElement;
    }

    @Nonnull
    protected EncryptedElementType placeKeysAsPeers(@Nonnull EncryptedElementType encElement, @Nonnull EncryptedData encData, @Nonnull List<EncryptedKey> encKeys) {
        this.log.debug("Placing EncryptedKey elements as peers of EncryptedData in EncryptedElementType");
        for (EncryptedKey encKey : encKeys) {
            if (encKey.getReferenceList() != null) continue;
            encKey.setReferenceList((ReferenceList)this.referenceListBuilder.buildObject());
        }
        if (encKeys.size() == 1) {
            this.linkSinglePeerKey(encData, encKeys.get(0));
        } else if (encKeys.size() > 1) {
            this.linkMultiplePeerKeys(encData, encKeys);
        }
        encElement.setEncryptedData(encData);
        encElement.getEncryptedKeys().addAll(encKeys);
        return encElement;
    }

    protected void linkSinglePeerKey(@Nonnull EncryptedData encData, @Nonnull EncryptedKey encKey) {
        ReferenceList refList;
        this.log.debug("Linking single peer EncryptedKey with RetrievalMethod and DataReference");
        KeyInfo keyInfo = encData.getKeyInfo();
        if (keyInfo != null) {
            RetrievalMethod rm = (RetrievalMethod)this.retrievalMethodBuilder.buildObject();
            rm.setURI("#" + encKey.getID());
            rm.setType("http://www.w3.org/2001/04/xmlenc#EncryptedKey");
            keyInfo.getRetrievalMethods().add(rm);
        }
        if ((refList = encKey.getReferenceList()) != null) {
            DataReference dr = (DataReference)this.dataReferenceBuilder.buildObject();
            dr.setURI("#" + encData.getID());
            refList.getDataReferences().add(dr);
        }
    }

    protected void linkMultiplePeerKeys(@Nonnull EncryptedData encData, @Nonnull List<EncryptedKey> encKeys) {
        String carriedKeyNameValue;
        this.log.debug("Linking multiple peer EncryptedKeys with CarriedKeyName and DataReference");
        KeyInfo keyInfo = encData.getKeyInfo();
        List dataEncKeyNames = keyInfo != null ? keyInfo.getKeyNames() : CollectionSupport.emptyList();
        if (dataEncKeyNames.size() == 0 || Strings.isNullOrEmpty((String)((KeyName)dataEncKeyNames.get(0)).getValue())) {
            String keyNameValue = this.idGenerator.generateIdentifier();
            this.log.debug("EncryptedData encryption key had no KeyName, generated one for use in CarriedKeyName: {}", (Object)keyNameValue);
            KeyName keyName = (KeyName)dataEncKeyNames.get(0);
            if (keyName == null) {
                keyName = (KeyName)this.keyNameBuilder.buildObject();
                dataEncKeyNames.add(keyName);
            }
            keyName.setValue(keyNameValue);
            carriedKeyNameValue = keyNameValue;
        } else {
            carriedKeyNameValue = ((KeyName)dataEncKeyNames.get(0)).getValue();
        }
        for (EncryptedKey encKey : encKeys) {
            CarriedKeyName carriedName = encKey.getCarriedKeyName();
            if (carriedName == null) {
                carriedName = (CarriedKeyName)this.carriedKeyNameBuilder.buildObject();
                encKey.setCarriedKeyName(carriedName);
            }
            carriedName.setValue(carriedKeyNameValue);
            ReferenceList refList = encKey.getReferenceList();
            if (refList == null) continue;
            DataReference dr = (DataReference)this.dataReferenceBuilder.buildObject();
            dr.setURI("#" + encData.getID());
            refList.getDataReferences().add(dr);
        }
    }

    public static enum KeyPlacement {
        PEER,
        INLINE;

    }
}

