/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import jakarta.jws.WebService;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.IAnnotationFinder;

public class CheckAnnotations
extends ValidationBase {
    Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_VALIDATION, CheckAnnotations.class);

    @Override
    public void validate(AppModule appModule) {
        try {
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                this.module = ejbModule;
                this.findClassesAnnotatedWithWebService(ejbModule);
            }
            for (WebModule webModule : appModule.getWebModules()) {
                this.module = webModule;
                this.findClassesAnnotatedWithWebService(webModule);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while validating @WebService annotation", e);
        }
    }

    private void findClassesAnnotatedWithWebService(EjbModule ejbModule) {
        IAnnotationFinder finder = ejbModule.getFinder();
        if (finder != null) {
            this.findIncorrectAnnotationAndWarn(finder, ejbModule.toString());
        }
    }

    private void findClassesAnnotatedWithWebService(WebModule webModule) {
        IAnnotationFinder finder = webModule.getFinder();
        if (finder != null) {
            this.findIncorrectAnnotationAndWarn(finder, webModule.toString());
        }
    }

    private void findIncorrectAnnotationAndWarn(IAnnotationFinder finder, String component) {
        List webserviceAnnotatedClasses = finder.findAnnotatedClasses(WebService.class);
        for (Class clazz : webserviceAnnotatedClasses) {
            Annotation[] annotations = clazz.getDeclaredAnnotations();
            List<Annotation> declaredAnnotations = Arrays.asList(annotations);
            for (Annotation declaredAnn : declaredAnnotations) {
                if (declaredAnn.annotationType().getName().equals("jakarta.ejb.Stateful")) {
                    this.warn(component, "annotation.invalid.stateful.webservice", clazz.getName());
                }
                if (declaredAnn.annotationType().getName().equals("jakarta.annotation.ManagedBean")) {
                    this.warn(component, "annotation.invalid.managedbean.webservice", clazz.getName());
                }
                if (!declaredAnn.annotationType().getName().equals("jakarta.ejb.MessageDriven")) continue;
                this.warn(component, "annotation.invalid.messagedriven.webservice", clazz.getName());
            }
        }
    }
}

