/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConfigSource;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class MapBackedConfigValueConfigSource
extends AbstractConfigSource
implements ConfigValueConfigSource {
    private static final long serialVersionUID = -4619155951589529987L;
    private final Map<String, ConfigValue> properties = new HashMap<String, ConfigValue>();

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap) {
        this(name, propertyMap, 100);
    }

    public MapBackedConfigValueConfigSource(String name, Map<String, ConfigValue> propertyMap, int defaultOrdinal) {
        super(name, ConfigSourceUtil.getOrdinalFromMap((Map)new ConfigValueConfigSource.ConfigValueMapView(propertyMap), (int)defaultOrdinal));
        for (Map.Entry<String, ConfigValue> entry : propertyMap.entrySet()) {
            this.properties.put(entry.getKey(), entry.getValue().from().withConfigSourceOrdinal(this.getOrdinal()).build());
        }
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public ConfigValue getConfigValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public Map<String, ConfigValue> getConfigValueProperties() {
        return this.properties;
    }
}

