/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.soap;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.ServiceLoaderUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class FactoryFinder {
    private static final Logger logger;
    private static final ServiceLoaderUtil.ExceptionHandler<SOAPException> EXCEPTION_HANDLER;
    private static final PrivilegedAction<String> propertyAction;
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String defaultClassName, boolean tryFallback) throws SOAPException {
        T result;
        Object result2;
        ClassLoader tccl = ServiceLoaderUtil.contextClassLoader(EXCEPTION_HANDLER);
        String factoryId = factoryClass.getName();
        String className = FactoryFinder.fromSystemProperty(factoryId);
        if (className != null && (result2 = FactoryFinder.newInstance(className, defaultClassName, tccl)) != null) {
            return (T)result2;
        }
        T factory = ServiceLoaderUtil.firstByServiceLoader(factoryClass, logger, EXCEPTION_HANDLER);
        if (factory != null) {
            return factory;
        }
        if (FactoryFinder.isOsgi() && (result = FactoryFinder.lookupUsingOSGiServiceLoader(factoryId)) != null) {
            return result;
        }
        if (!tryFallback) {
            return null;
        }
        if (defaultClassName == null) {
            throw new SOAPException("Provider for " + factoryId + " cannot be found", null);
        }
        logger.fine("Trying to create the default implementation of the message factory");
        return (T)FactoryFinder.newInstance(defaultClassName, defaultClassName, tccl);
    }

    private static Object newInstance(String className, String defaultClassName, ClassLoader tccl) throws SOAPException {
        Object newInstance = ServiceLoaderUtil.newInstance(className, defaultClassName, tccl, EXCEPTION_HANDLER);
        if (logger.isLoggable(Level.FINE)) {
            Class<?> newInstanceClass = newInstance.getClass();
            logger.log(Level.FINE, "loaded {0} from {1}", new Object[]{newInstanceClass.getName(), FactoryFinder.which(newInstanceClass)});
        }
        return newInstance;
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = FactoryFinder.getSystemProperty(factoryId);
        if (systemProp != null) {
            return systemProp;
        }
        return null;
    }

    private static String getSystemProperty(final String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
        FactoryFinder.logFound(value);
        return value;
    }

    private static void logFound(String value) {
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            logger.log(Level.FINER, "Class org.glassfish.hk2.osgiresourcelocator.ServiceLoader cannot be loaded", ignored);
            return false;
        }
    }

    private static <T> T lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            logger.fine("Trying to create the provider from the OSGi ServiceLoader");
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? (T)iter.next() : null;
        }
        catch (Exception ignored) {
            logger.log(Level.FINER, "Access to the system property with key " + factoryId + " is not allowed", ignored);
            return null;
        }
    }

    static URL which(Class<?> clazz) {
        return FactoryFinder.which(clazz, FactoryFinder.getClassClassLoader(clazz));
    }

    static URL which(Class<?> clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = FactoryFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    private static ClassLoader getClassClassLoader(Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(c::getClassLoader);
    }

    static {
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<SOAPException>(){

            @Override
            public SOAPException createException(Throwable throwable, String message) {
                return new SOAPException(message, throwable);
            }
        };
        propertyAction = () -> System.getProperty("saaj.debug");
        logger = Logger.getLogger("jakarta.xml.soap");
        try {
            if (AccessController.doPrivileged(propertyAction) != null) {
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                logger.addHandler(handler);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during loading the class", t);
        }
    }
}

