/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.ArrayList;

public final class StringUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Byte BYTE_ZERO = 0;
    private static final Character CHAR_ZERO = Character.valueOf('\u0000');
    private static final Double DOUBLE_ZERO = 0.0;
    private static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    private static final Integer INTEGER_ZERO = 0;
    private static final Long LONG_ZERO = 0L;
    private static final Short SHORT_ZERO = 0;

    private StringUtil() {
    }

    public static boolean isEmpty(String val) {
        return val == null || val.isEmpty();
    }

    public static boolean isNotEmpty(String val) {
        return !StringUtil.isEmpty(val);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static boolean contains(String val, char charToSearchFor) {
        return val != null && val.indexOf(charToSearchFor) > -1;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return str1 == str2;
        }
        if (str1 == str2) {
            return true;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String[] split(String str, String token, int max) {
        if (str == null || str.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (token == null || token.length() == 0) {
            throw new IllegalArgumentException("token: [" + token + "]");
        }
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        int len = str.length();
        int tlen = token.length();
        int pos = 0;
        while (pos != -1) {
            pos = str.indexOf(token, start);
            if (pos == -1) continue;
            ret.add(str.substring(start, pos));
            start = pos + tlen;
        }
        if (start < len) {
            ret.add(str.substring(start));
        } else if (start == len) {
            ret.add("");
        }
        if (max == 0) {
            int size = ret.size();
            while (((String)ret.get(--size)).isEmpty()) {
                ret.remove(size);
            }
        } else if (max > 0 && ret.size() > max) {
            StringBuilder sb = new StringBuilder(256);
            sb.append((String)ret.get(max - 1));
            ret.remove(max - 1);
            while (ret.size() >= max) {
                sb.append(token).append((String)ret.get(max - 1));
                ret.remove(max - 1);
            }
            ret.add(sb.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String replace(String str, String from, String to) {
        if (from.equals(to)) {
            return str;
        }
        Object[] split = StringUtil.split(str, from, Integer.MAX_VALUE);
        return StringUtil.join(split, to);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public static String join(Object[] values, String joinToken) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            return values[0].toString();
        }
        if (joinToken == null) {
            joinToken = "null";
        }
        StringBuilder sb = new StringBuilder(values.length * (16 + joinToken.length()));
        sb.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.append(joinToken).append(values[i]);
        }
        return sb.toString();
    }

    public static <T> T parse(String val, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("target type must not be null");
        }
        if (type == Byte.TYPE) {
            return (T)(val == null ? BYTE_ZERO : Byte.valueOf(val));
        }
        if (type == Character.TYPE) {
            return (T)(val == null ? CHAR_ZERO : StringUtil.parseCharString(val));
        }
        if (type == Double.TYPE) {
            return (T)(val == null ? DOUBLE_ZERO : Double.valueOf(val));
        }
        if (type == Float.TYPE) {
            return (T)(val == null ? FLOAT_ZERO : Float.valueOf(val));
        }
        if (type == Integer.TYPE) {
            return (T)(val == null ? INTEGER_ZERO : Integer.valueOf(val));
        }
        if (type == Long.TYPE) {
            return (T)(val == null ? LONG_ZERO : Long.valueOf(val));
        }
        if (type == Short.TYPE) {
            return (T)(val == null ? SHORT_ZERO : Short.valueOf(val));
        }
        if (type == Boolean.TYPE) {
            return (T)(val == null ? Boolean.FALSE : Boolean.valueOf(val));
        }
        if (type == Void.TYPE) {
            throw new IllegalStateException("Cannot parse void type");
        }
        if (type == Byte.class) {
            return (T)(val == null ? null : Byte.valueOf(val));
        }
        if (type == Character.class) {
            return (T)(val == null ? null : StringUtil.parseCharString(val));
        }
        if (type == Double.class) {
            return (T)(val == null ? null : Double.valueOf(val));
        }
        if (type == Float.class) {
            return (T)(val == null ? null : Float.valueOf(val));
        }
        if (type == Integer.class) {
            return (T)(val == null ? null : Integer.valueOf(val));
        }
        if (type == Long.class) {
            return (T)(val == null ? null : Long.valueOf(val));
        }
        if (type == Short.class) {
            return (T)(val == null ? null : Short.valueOf(val));
        }
        if (type == Boolean.class) {
            return (T)(val == null ? null : Boolean.valueOf(val));
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getCanonicalName());
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(firstChar)).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(firstChar)).append(str.substring(1)).toString();
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        int strlen = str.length();
        if (suffix.length() > strlen) {
            return false;
        }
        return str.substring(str.length() - suffix.length(), strlen).equalsIgnoreCase(suffix);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    private static Character parseCharString(String val) {
        if (val.length() == 0) {
            return Character.valueOf('\u0000');
        }
        if (val.length() == 1) {
            return Character.valueOf(val.charAt(0));
        }
        throw new IllegalArgumentException("'" + val + "' is longer than one character.");
    }
}

