/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.xml;

import jakarta.validation.ValidationException;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.UnmarshallerHandler;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaManager {
    public static final String VERSION_ATTRIBUTE = "version";
    private static final Logger log = Logger.getLogger(SchemaManager.class.getName());
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private final Key target;
    private final Map<Key, Lazy<Schema>> data;
    private final String description;

    static Schema loadSchema(String resource) {
        URL schemaUrl = Reflection.loaderFromClassOrThread(SchemaManager.class).getResource(resource);
        try {
            return SCHEMA_FACTORY.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            log.log(Level.WARNING, String.format("Unable to parse schema: %s", resource), e);
            return null;
        }
    }

    private static Class<?> getObjectFactory(Class<?> type) throws ClassNotFoundException {
        String className = String.format("%s.%s", type.getPackage().getName(), "ObjectFactory");
        return Reflection.toClass(className, type.getClassLoader());
    }

    private SchemaManager(Map<Key, Lazy<Schema>> data) {
        this.data = Collections.unmodifiableMap(data);
        this.target = (Key)data.keySet().stream().skip(data.size() - 1).findFirst().orElseThrow(IllegalStateException::new);
        this.description = this.target.ns.substring(this.target.ns.lastIndexOf(47) + 1);
    }

    public Optional<Schema> getSchema(String ns, String version) {
        return Optional.of(new Key(version, ns)).map(this.data::get).map(Lazy::get);
    }

    public Optional<Schema> getSchema(Document document) {
        return Optional.ofNullable(document).map(Document::getDocumentElement).map(e -> this.getSchema(e.getAttribute("xmlns"), e.getAttribute(VERSION_ATTRIBUTE))).get();
    }

    public <E extends Exception> Schema requireSchema(Document document, Function<String, E> exc) throws E {
        return this.getSchema(document).orElseThrow(() -> (Exception)Objects.requireNonNull(exc, "exc").apply(String.format("Unknown %s schema", Objects.toString(this.description, ""))));
    }

    public <T> T unmarshal(InputSource input, Class<T> type) throws Exception {
        XMLReader xmlReader = SAX_PARSER_FACTORY.newSAXParser().getXMLReader();
        DynamicValidatorHandler schemaValidator = new DynamicValidatorHandler();
        xmlReader.setContentHandler(schemaValidator);
        SchemaRewriter schemaRewriter = new SchemaRewriter();
        schemaValidator.setContentHandler(schemaRewriter);
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SchemaManager.getObjectFactory(type)});
        UnmarshallerHandler unmarshallerHandler = jc.createUnmarshaller().getUnmarshallerHandler();
        schemaRewriter.setContentHandler((ContentHandler)unmarshallerHandler);
        xmlReader.parse(input);
        schemaValidator.validate();
        JAXBElement result = (JAXBElement)unmarshallerHandler.getResult();
        return (T)result.getValue();
    }

    static {
        SAX_PARSER_FACTORY.setNamespaceAware(true);
    }

    private class SchemaRewriter
    extends XMLFilterImpl {
        private boolean root = true;
        private Key rootSchemaKey = null;

        private SchemaRewriter() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.root) {
                this.rootSchemaKey = new Key(Objects.toString(atts.getValue(SchemaManager.VERSION_ATTRIBUTE), SchemaManager.this.data.keySet().iterator().next().getVersion()), uri);
            }
            if (!SchemaManager.this.target.equals(this.rootSchemaKey)) {
                uri = SchemaManager.this.target.ns;
                if (this.root) {
                    atts = this.rewriteVersion(atts);
                    this.root = false;
                }
            }
            super.startElement(uri, localName, qName, atts);
        }

        private Attributes rewriteVersion(Attributes atts) {
            AttributesImpl result = atts instanceof AttributesImpl ? (AttributesImpl)atts : new AttributesImpl(atts);
            this.set(result, "", SchemaManager.VERSION_ATTRIBUTE, "", XmlAttributeType.CDATA, SchemaManager.this.target.version);
            return result;
        }

        private void set(AttributesImpl attrs, String uri, String localName, String qName, XmlAttributeType type, String value) {
            int sz = attrs.getLength();
            for (int i = 0; i < sz; ++i) {
                if (!Objects.equals(qName, attrs.getQName(i)) && (!Objects.equals(uri, attrs.getURI(i)) || !Objects.equals(localName, attrs.getLocalName(i)))) continue;
                attrs.setAttribute(i, uri, localName, qName, type.name(), value);
                return;
            }
            attrs.addAttribute(uri, localName, qName, type.name(), value);
        }
    }

    private static enum XmlAttributeType {
        CDATA,
        ID,
        IDREF,
        IDREFS,
        NMTOKEN,
        NMTOKENS,
        ENTITY,
        ENTITIES,
        NOTATION;

    }

    private class DynamicValidatorHandler
    extends XMLFilterImpl {
        ContentHandler ch;
        SAXParseException e;

        private DynamicValidatorHandler() {
        }

        @Override
        public void setContentHandler(ContentHandler handler) {
            super.setContentHandler(handler);
            this.ch = handler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.getContentHandler() == this.ch) {
                String version = Objects.toString(atts.getValue(SchemaManager.VERSION_ATTRIBUTE), SchemaManager.this.data.keySet().iterator().next().getVersion());
                Key schemaKey = new Key(version, uri);
                Exceptions.raiseUnless(SchemaManager.this.data.containsKey(schemaKey), ValidationException::new, "Unknown validation schema %s", schemaKey);
                Schema schema = SchemaManager.this.data.get(schemaKey).get();
                ValidatorHandler vh = schema.newValidatorHandler();
                vh.startDocument();
                vh.setContentHandler(this.ch);
                super.setContentHandler(vh);
            }
            try {
                super.startElement(uri, localName, qName, atts);
            }
            catch (SAXParseException e) {
                this.e = e;
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.e = e;
            super.error(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.e = e;
            super.fatalError(e);
        }

        void validate() throws SAXParseException {
            if (this.e != null) {
                throw this.e;
            }
        }
    }

    private static class Key
    implements Comparable<Key> {
        private static final Comparator<Key> CMP = Comparator.comparing(Key::getVersion).thenComparing(Key::getNs);
        final String version;
        final String ns;

        Key(String version, String ns) {
            Validate.isTrue(StringUtils.isNotBlank(version), "version cannot be null/empty/blank", new Object[0]);
            this.version = version;
            Validate.isTrue(StringUtils.isNotBlank(ns), "ns cannot be null/empty/blank", new Object[0]);
            this.ns = ns;
        }

        public String getVersion() {
            return this.version;
        }

        public String getNs() {
            return this.ns;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return Optional.ofNullable(obj).filter(Key.class::isInstance).map(Key.class::cast).filter(k -> Objects.equals(this.version, k.version) && Objects.equals(this.ns, k.ns)).isPresent();
        }

        public int hashCode() {
            return Objects.hash(this.version, this.ns);
        }

        public String toString() {
            return String.format("%s:%s", this.version, this.ns);
        }

        @Override
        public int compareTo(Key o) {
            return CMP.compare(this, o);
        }
    }

    public static class Builder {
        private final Map<Key, Lazy<Schema>> data = new LinkedHashMap<Key, Lazy<Schema>>();

        public Builder add(String version, String ns, String resource) {
            this.data.put(new Key(version, ns), new Lazy<Schema>(() -> SchemaManager.loadSchema(resource)));
            return this;
        }

        public SchemaManager build() {
            return new SchemaManager(this.data);
        }
    }
}

