/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.taeconfigurator.editors.Form2Panel;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class HeaderPage
extends FormPage {
    public static final boolean EQUAL_WIDTH = true;
    protected SashForm sashForm;
    protected MultiPageEditor editor;
    protected FormToolkit toolkit;
    protected Composite leftPanel;
    protected Composite rightPanel;
    protected int sashFormWidth;
    protected float leftPanelPercent;
    protected float rightPanelPercent;
    protected int leftPanelWidth;
    protected int rightPanelWidth;

    public HeaderPage(MultiPageEditor formEditor, String id, String keyPageTitle) {
        super((FormEditor)formEditor, id, keyPageTitle);
        this.editor = formEditor;
        this.toolkit = this.editor.getToolkit();
    }

    public HeaderPage(MultiPageEditor formEditor, String pageTitle) {
        this(formEditor, "UID_" + pageTitle, pageTitle);
    }

    protected void maybeInitialize(IManagedForm managedForm) {
    }

    public Composite newComposite(Composite parent) {
        return this.newnColumnSection(parent, 1);
    }

    public Composite newCentered2SpanComposite(Composite parent) {
        this.spacer(parent);
        Composite composite = this.newComposite(parent);
        ((GridData)composite.getLayoutData()).horizontalSpan = 2;
        return composite;
    }

    public Composite newnColumnSection(Composite parent, int cols) {
        Composite section = this.toolkit.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = cols;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        section.setLayout((Layout)layout);
        section.setLayoutData((Object)new GridData(1808));
        return section;
    }

    public Composite setup1ColumnLayout(IManagedForm managedForm) {
        ScrolledForm sform = managedForm.getForm();
        Composite form = sform.getBody();
        form.setLayout((Layout)new GridLayout(1, false));
        Composite xtra = this.toolkit.createComposite(form);
        xtra.setLayout((Layout)new GridLayout(1, false));
        xtra.setLayoutData((Object)new GridData(1808));
        Composite c = form.getParent();
        while (!(c instanceof ScrolledComposite)) {
            c = c.getParent();
        }
        ((GridData)xtra.getLayoutData()).widthHint = c.getSize().x;
        return xtra;
    }

    public Composite setup2ColumnGrid(IManagedForm managedForm, boolean equalWidth) {
        ScrolledForm sform = managedForm.getForm();
        Composite form = sform.getBody();
        GridLayout layout = new GridLayout(2, equalWidth);
        form.setLayout((Layout)layout);
        form.setLayoutData((Object)new GridData(1808));
        return form;
    }

    public Form2Panel setup2ColumnLayout(IManagedForm managedForm, int w1, int w2) {
        ScrolledForm sform = managedForm.getForm();
        Composite form = sform.getBody();
        form.setLayout((Layout)new GridLayout(1, false));
        Composite xtra = this.toolkit.createComposite(form);
        xtra.setLayout((Layout)new GridLayout(1, false));
        xtra.setLayoutData((Object)new GridData(1808));
        Composite c = xtra.getParent();
        while (!(c instanceof ScrolledComposite)) {
            c = c.getParent();
        }
        ((GridData)xtra.getLayoutData()).widthHint = c.getSize().x;
        ((GridData)xtra.getLayoutData()).heightHint = c.getSize().y;
        this.sashForm = new SashForm(xtra, 256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.leftPanel = this.newComposite((Composite)this.sashForm);
        ((GridLayout)this.leftPanel.getLayout()).marginHeight = 5;
        ((GridLayout)this.leftPanel.getLayout()).marginWidth = 5;
        this.rightPanel = this.newComposite((Composite)this.sashForm);
        ((GridLayout)this.rightPanel.getLayout()).marginHeight = 5;
        ((GridLayout)this.rightPanel.getLayout()).marginWidth = 5;
        this.sashForm.setWeights(new int[]{w1, w2});
        this.leftPanelPercent = (float)w1 / (float)(w1 + w2);
        this.rightPanelPercent = (float)w2 / (float)(w1 + w2);
        this.rightPanel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HeaderPage.this.setSashFormWidths();
            }
        });
        return new Form2Panel(form, this.leftPanel, this.rightPanel);
    }

    void setSashFormWidths() {
        this.sashFormWidth = this.sashForm.getSize().x;
        int[] ws = this.sashForm.getWeights();
        this.leftPanelWidth = (int)((float)ws[0] / (float)(ws[0] + ws[1]) * (float)this.sashFormWidth);
        this.rightPanelWidth = (int)((float)ws[1] / (float)(ws[0] + ws[1]) * (float)this.sashFormWidth);
    }

    public Form2Panel setup2ColumnLayout(IManagedForm managedForm, boolean equalWidth) {
        if (equalWidth) {
            return this.setup2ColumnLayout(managedForm, 50, 50);
        }
        return this.setup2ColumnLayout(managedForm, 60, 40);
    }

    public Form2Panel setup2ColumnLayoutNotSash(IManagedForm managedForm, boolean equalWidth) {
        final ScrolledForm sform = managedForm.getForm();
        Composite form = sform.getBody();
        GridLayout layout = new GridLayout(2, equalWidth);
        form.setLayout((Layout)layout);
        form.setLayoutData((Object)new GridData(1808));
        this.leftPanel = this.newComposite(form);
        this.rightPanel = this.newComposite(form);
        sform.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                float col1CurrentWidth = HeaderPage.this.leftPanel.getSize().x;
                float col2CurrentWidth = HeaderPage.this.rightPanel.getSize().x;
                int minLeftPanelWidth = 250;
                int minRightPanelWidth = (int)(col2CurrentWidth * 250.0f / col1CurrentWidth);
                ((GridData)HeaderPage.this.leftPanel.getLayoutData()).widthHint = 250;
                ((GridData)HeaderPage.this.rightPanel.getLayoutData()).widthHint = minRightPanelWidth;
                sform.removeListener(11, (Listener)this);
            }
        });
        return new Form2Panel(form, this.leftPanel, this.rightPanel);
    }

    public Form2Panel setup2ColumnLayoutOn4Grid(IManagedForm managedForm, boolean equalWidth) {
        Form2Panel f = this.setup2ColumnLayoutNotSash(managedForm, equalWidth);
        ((GridLayout)f.form.getLayout()).numColumns = 4;
        ((GridData)f.left.getLayoutData()).horizontalSpan = 2;
        ((GridData)f.right.getLayoutData()).horizontalSpan = 2;
        return f;
    }

    protected void spacer(Composite container) {
        this.toolkit.createLabel(container, " ");
    }

    public void markStale() {
        if (this.getManagedForm() != null) {
            IFormPart[] parts = this.getManagedForm().getParts();
            for (int i = 0; i < parts.length; ++i) {
                ((AbstractFormPart)parts[i]).markStale();
            }
        }
    }

    protected boolean isPrimitive() {
        return this.editor.getAeDescription().isPrimitive();
    }

    protected boolean isAeDescriptor() {
        return this.editor.isAeDescriptor();
    }

    public boolean isTypeSystemDescriptor() {
        return this.editor.isTypeSystemDescriptor();
    }

    public boolean isIndexDescriptor() {
        return this.editor.isFsIndexCollection();
    }

    public boolean isTypePriorityDescriptor() {
        return this.editor.isTypePriorityDescriptor();
    }

    public boolean isExtResAndBindingsDescriptor() {
        return this.editor.isExtResAndBindingsDescriptor();
    }

    public boolean isCollectionReaderDescriptor() {
        return this.editor.isCollectionReaderDescriptor();
    }

    public boolean isCasInitializerDescriptor() {
        return this.editor.isCasInitializerDescriptor();
    }

    public boolean isCasConsumerDescriptor() {
        return this.editor.isCasConsumerDescriptor();
    }

    public boolean isLocalProcessingDescriptor() {
        return this.editor.isLocalProcessingDescriptor();
    }

    protected AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return this.editor.getAeDescription().getAnalysisEngineMetaData();
    }
}

